<?php
/**
 * The template for displaying product content within loops
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/content-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce/Templates
 * @version 3.6.0
 */

defined( 'ABSPATH' ) || exit;

global $product;
$prefix = '_studiare_';
$download_icon = get_post_meta( get_the_ID(), $prefix . 'download_icon', 1 ) ;

// Ensure visibility.
if ( empty( $product ) || ! $product->is_visible() ) {
	return;
}

add_filter( 'excerpt_length', 'studiare_product_custom_excerpt_length', 999 );

// Custom Meta
$sale_price = $product->get_sale_price();
$regular_price = $product->get_regular_price();
$prefix = '_studiare_';
$teacher_id = get_post_meta( get_the_ID(), $prefix . 'course_teacher', true );
$stock = get_post_meta( get_the_ID(), '_stock', true );

$courses_cart_loop = true;
$courses_teacher_loop = true;
$course_students = true;
$courses_rating_loop = true;
if ( class_exists( 'Redux' ) ) {
	$course_students = codebean_option('course_students');
	$course_video_loop = codebean_option('course_video_loop');
}
	if ( function_exists( 'dokan' ) ) {
$product_id = is_callable( array( $product, 'get_id' ) ) ? $product->get_id() : $product->ID;
$user_id = get_post_field( 'post_author', $product_id );
$store_user = get_user_by( 'id', $user_id );
$store_info = dokan_get_store_info( $store_user->ID );
}
?>
<div <?php post_class( 'course-item' ); ?>>

<!--    --><?php //do_action( 'woocommerce_before_shop_loop_item' ); ?>

    <div class="download-item-icon-inner">
			<div class="download-icon-box">
   				<a href="<?php the_permalink(); ?>" class="image-icon">
						<div class="mximgbox">
							<img src="<?php echo esc_url( $download_icon ); ?>">
						</div>
						<h3><?php the_title(); ?></h3>
					</a>
								<h4 class="desc-icon">توضیحات محصول </h4>
								<p class="download-icon"><?php the_excerpt(); ?></p>

								<div class="icon-meta">

									<div class="course-students">
										<?php if ( $course_students ) : ?>
											<i class="fa fa-download"></i><span><?php $count = get_post_meta(get_the_ID(),'total_sales', true); $text = sprintf( _n( '%s', '%s', $count, 'wpdocs_textdomain' ), number_format_i18n($count));echo $text;  ?>
										<?php endif; ?>
									</div>
										<div class="course-price">
											<?php woocommerce_template_loop_price(); ?>
										</div>
								</div>
			</div>
    </div>
</div>
