<?php
$custom_logo_image = get_theme_file_uri('assets/images/logo_default-footer.png');

if ( class_exists( 'Redux') ) {
	$logo_uploaded = codebean_option('footer_logo_');
	if(isset($logo_uploaded['url']) && $logo_uploaded['url'] != '') {
		$custom_logo_image = $logo_uploaded['url'];
	}

}

$right_menu = wp_nav_menu(
	array(
		'theme_location'    => 'footer-right-menu',
		'menu_class'        => 'footer-botoom-menu',
		'echo'				=> false
	)
);
$left_menu = wp_nav_menu(
	array(
		'theme_location'    => 'footer-left-menu',
		'menu_class'        => 'footer-botoom-menu',
		'echo'				=> false
	)
);



?>
<div class="container">
	<div class="footer__mainmenu">

		<nav class="footer__mainmenu-list">
			<?php echo wp_kses_post($right_menu); ?>
		</nav>

		<a href="<?php echo esc_url( home_url('/') ); ?>" class="studiare-logo studiare-main-logo" rel="home">
				<img src="<?php echo esc_url( $custom_logo_image ); ?>" alt="<?php echo esc_attr( get_bloginfo( 'name' ) ); ?>">
		</a>

		<nav class="footer__mainmenu-list">
			<?php echo wp_kses_post($left_menu); ?>
		</nav>

	</div>
</div>
