<?php

# Testimonials Parent
vc_map( array(
	'base'             => 'cdb_testimonials',
	'name'             => esc_html__( 'Testimonials', 'gigafile' ),
	'description'      => esc_html__( 'User testimonials slider or grid', 'gigafile' ),
	'as_parent'        => array('only' => 'cdb_testimonial_item'),
	'category'         => esc_html__( 'Studiare', 'gigafile' ),
	'params'           => array(
		array(
			'type'          => 'checkbox',
			'heading'       => esc_html__( 'Show Pagination', 'gigafile' ),
			'param_name'    => 'show_pagination_control',
			'description'   => esc_html__( 'If "YES" pagination control will be added', 'gigafile' ),
		),
		array(
			'type'          => 'checkbox',
			'heading'       => esc_html__( 'Slider Loop', 'gigafile' ),
			'param_name'    => 'wrap',
			'description'   => esc_html__( 'Enables loop mode for slider', 'gigafile' ),
		),

		array(
		'type' => 'dropdown',
		'heading' => esc_html__( 'تعداد ستون ها', 'gigafile' ),
		'param_name' => 'slides_per_view',
		'value' => array(
			1,2,3,4
		),
		'std' => 3,
	),

		array(
			'type'          => 'textfield',
			'heading'       => esc_html__( 'Extra class name', 'gigafile' ),
			'param_name'    => 'el_class',
			'description'   => esc_html__( 'If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.', 'gigafile' )
		),

		array(
			'type'       => 'css_editor',
			'heading'    => 'Css',
			'param_name' => 'css',
			'group'      => esc_html__( 'Design options', 'gigafile' ),
		)
	),
	'js_view'          => 'VcColumnView'
) );

# Testimonials Child
vc_map( array(
	'base'             => 'cdb_testimonial_item',
	'name'             => esc_html__( 'Testimonial', 'gigafile' ),
	'description'      => esc_html__( 'User testimonial', 'gigafile' ),
	'as_child'         => array('only' => 'cdb_testimonials'),
	'category'         => esc_html__( 'Studiare', 'gigafile' ),
	'params'           => array(
		array(
			'type'          => 'textfield',
			'heading'       => esc_html__( 'Name', 'gigafile' ),
			'param_name'    => 'name',
			'description'   => esc_html__( 'User name', 'gigafile' )
		),
		array(
			'type'          => 'textfield',
			'heading'       => esc_html__( 'User Role', 'gigafile' ),
			'param_name'    => 'user_role',
			'description'   => esc_html__( 'User role', 'gigafile' )
		),
		array(
			'type'          => 'attach_image',
			'heading'       => esc_html__( 'User Avatar', 'gigafile' ),
			'param_name'    => 'image',
			'value'         => '',
			'description'   => esc_html__( 'Select image from media library.', 'gigafile' )
		),
		array(
			'type'          => 'textfield',
			'heading'       => esc_html__( 'Image size', 'gigafile' ),
			'param_name'    => 'img_size',
			'description'   => esc_html__( 'Enter image size. Example: "thumbnail", "medium", "large", "full" or other sizes defined by current theme. Alternatively enter image size in pixels: 200x100 (Width x Height). Leave empty to use "thumbnail" size.', 'gigafile' )
		),
		array(
			'type'          => 'textarea_html',
			'holder'        => 'blockquote',
			'heading'       => esc_html__( 'Text', 'gigafile' ),
			'param_name'    => 'content'
		),
		array(
			'type'          => 'textfield',
			'heading'       => esc_html__( 'Extra class name', 'gigafile' ),
			'param_name'    => 'el_class',
			'description'   => esc_html__( 'If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.', 'gigafile' )
		),
	)
) );

if ( class_exists('WPBakeryShortCodesContainer') ) {
	class WPBakeryShortCode_Cdb_Testimonials extends WPBakeryShortCodesContainer {}
}

if ( class_exists( 'WPBakeryShortCode' ) ) {
	class WPBakeryShortCode_Cdb_Testimonial_Item extends WPBakeryShortCode {}
}
