<?php
/**
 * Nuovo WordPress Theme
 *
 * Codebean.co
 * www.codebean.co
 */

vc_map( array(
	'base'             => 'cdb_social_networks',
	'name'             => esc_html__( 'Social Networks', 'gigafile' ),
	'description'      => esc_html__( 'Social network links', 'gigafile' ),
	'category'         => esc_html__( 'Studiare', 'gigafile' ),
	'params'           => array(
		array(
			'type' => 'dropdown',
			'heading' => esc_html__( 'Display type', 'gigafile' ),
			'param_name' => 'display_type',
			'value' => array(
				esc_html__( 'Rounded Icon', 'gigafile' ) => 'rounded',
				esc_html__( 'Icon Only', 'gigafile' ) => 'icon-only',
			),
			'description' => esc_html__( 'Select style of social network links.', 'gigafile' ),
			'admin_label' => true
		),
		array(
			'type'       => 'checkbox',
			'heading'    => esc_html__( 'Light?', 'gigafile' ),
			'param_name' => 'light',
			'admin_label' => true,
		),
		array(
			'type'           => 'textfield',
			'heading'        => esc_html__( 'Extra class name', 'gigafile' ),
			'param_name'     => 'el_class',
			'description'    => esc_html__( 'If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.', 'gigafile' ),
		),
		array(
			'type'       => 'css_editor',
			'heading'    => 'Css',
			'param_name' => 'css',
			'group'      => esc_html__( 'Design options', 'gigafile' ),
		)
	)
) );

if ( class_exists('WPBakeryShortCode' ) ) {
	class WPBakeryShortCode_Cdb_Social_Networks extends WPBakeryShortCode {}
}