<?php

vc_map( array(
	'base'             => 'cdb_pricing_table',
	'name'             => esc_html__( 'Pricing Table', 'gigafile' ),
	'description'      => esc_html__( 'Insert pricing table with icon', 'gigafile' ),
	'category'         => esc_html__( 'Studiare', 'gigafile' ),
	'params'           => array(
		array(
			'type'          => 'textfield',
			'admin_label'   => true,
			'heading'       => esc_html__('Title','gigafile' ),
			'param_name'    => 'title',
			'value'         => esc_html__('Basic Plan','gigafile' )
		),
		array(
			'type'          => 'textfield',
			'admin_label'   => true,
			'heading'       => esc_html__('Subtitle','gigafile' ),
			'param_name'    => 'subtitle',
			'value'         => ''
		),
		array(
			'type'          => 'textfield',
			'admin_label'   => true,
			'heading'       => esc_html__('Price', 'gigafile' ),
			'param_name'    => 'price'
		),
		array(
			'type'          => 'textfield',
			'admin_label'   => true,
			'heading'       => esc_html__('Currency', 'gigafile' ),
			'param_name'    => 'currency'
		),
		array(
			'type'          => 'dropdown',
			'heading'       => esc_html__('Show Button', 'gigafile' ),
			'param_name'    => 'show_button',
			'value'         => array(
				esc_html__('Yes', 'gigafile' )     => 'yes',
				esc_html__('No', 'gigafile' )      => 'no'
			)
		),
		array(
			'type'          => 'vc_link',
			'heading'       => esc_html__('Button Link', 'gigafile' ),
			'param_name'    => 'button_link',
			'dependency'    => array(
				'element'   => 'show_button',
				'value'     => 'yes'
			),
		),
		array(
			'type'          => 'textfield',
			'heading'       => esc_html__('Button Text', 'gigafile' ),
			'param_name'    => 'button_text'
		),
		array(
			'type'          => 'textarea_html',
			'holder'        => 'div',
			'class'         => '',
			'heading'       => esc_html__('Content', 'gigafile' ),
			'param_name'    => 'content',
			'value'         => '<li>' . esc_html__('content content content', 'gigafile' ) . '</li><li>' . esc_html__('content content content', 'gigafile' ) . '</li><li>' . esc_html__('content content content', 'gigafile' ) . '</li>',
			'description'   => ''
		),
		array(
			'type'          => 'textfield',
			'heading'       => esc_html__('Extra class name','gigafile' ),
			'param_name'    => 'el_class',
			'description'   => esc_html__('If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.','gigafile' )
		),
		array(
			'type' => 'css_editor',
			'heading' => esc_html__( 'Css', 'gigafile' ),
			'param_name' => 'css',
			'group' => esc_html__( 'Design options', 'gigafile' )
		)
	)
) );

if ( class_exists('WPBakeryShortCode') ) {
	class WPBakeryShortCode_Cdb_Pricing_Table extends WPBakeryShortCode {}
}
