<?php

vc_map( array(
	'name'        => esc_html__( 'Portfolio', 'gigafile' ),
	'base'        => 'cdb_portfolio',
	'description'      => esc_html__( 'Show portfolio items', 'gigafile' ),
	'category'    => esc_html__( 'Studiare', 'gigafile' ),
	'params'      => array(
		array(
			'type' => 'loop',
			'heading' => esc_html__( 'Portfolio Items', 'gigafile' ),
			'param_name' => 'portfolio_query',
			'settings' => array(
				'size' => array('hidden' => false, 'value' => 4 * 3),
				'order_by' => array('value' => 'date'),
				'post_type' => array('value' => 'portfolio', 'hidden' => false)
			),
			'description' => esc_html__( 'Create WordPress loop, to populate content from your site.', 'gigafile' )
		),
		array(
			'type'           => 'dropdown',
			'heading'        => esc_html__( 'Category Filter', 'gigafile' ),
			'param_name'     => 'category_filter',
			'value'          => array(
				esc_html__( 'Yes', 'gigafile' ) => 'yes',
				esc_html__( 'No', 'gigafile' )  => 'no',
			),
			'description'    => esc_html__('Show category filter above the portfolio items.', 'gigafile' ),
			'admin_label'    => true
		),
		array(
			'type'           => 'dropdown',
			'heading'        => esc_html__( 'Columns', 'gigafile' ),
			'param_name'     => 'columns_count',
			'std'            => '4',
			'value'          => array(
				esc_html__( '2 Items per Row', 'gigafile' )    => 'two',
				esc_html__( '3 Items per Row', 'gigafile' )    => 'three',
				esc_html__( '4 Items per Row', 'gigafile' )    => 'four',
				esc_html__( '5 Items per Row', 'gigafile' )    => 'five',
				esc_html__( '6 Items per Row', 'gigafile' )    => 'six',
			),
			'description' => esc_html__( 'Number of columns to show portfolio items.', 'gigafile' ),
			'admin_label'    => true
		),
		array(
			'type' => 'textfield',
			'heading' => esc_html__( 'Extra class name', 'gigafile' ),
			'param_name' => 'el_class',
			'value' => '',
			'description' => esc_html__( 'If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.', 'gigafile' )
		),
		array(
			'type' => 'css_editor',
			'heading' => esc_html__( 'Css', 'gigafile' ),
			'param_name' => 'css',
			'group' => esc_html__( 'Design options', 'gigafile' )
		)
	)
) );


if ( class_exists('WPBakeryShortCode' ) ) {
	class WPBakeryShortCode_Cdb_Portfolio extends WPBakeryShortCode {}
}