<?php

if ( in_array( 'woocommerce/woocommerce.php', apply_filters( 'active_plugins', get_option( 'active_plugins' ) ) ) || codebean_is_plugin_active_for_network( 'woocommerce/woocommerce.php' ) ) {

	vc_map( array(
		'base'             => 'cdb_miniicon_carousel',
		'name'             => esc_html__( 'کروسل آیکونی با پاپ آپ', 'gigafile' ),
		'description'      => esc_html__( 'نمایش اسلایدر آیکونی با پاپ آپ تصویر کاور', 'gigafile' ),
		'category'         => esc_html__( 'Studiare', 'gigafile' ),
		'params'           => array(

			array(
			'type' => 'dropdown',
			'heading' => esc_html__( 'نوع محصول', 'gigafile' ),
			'param_name' => 'courses_type',
			'value' => array(
				esc_html__( 'همه محصولات', 'gigafile' ) => 'all',
				esc_html__( 'محصولات تخفیف دار', 'gigafile' ) => 'onsale',
				esc_html__( 'محصولات شاخص', 'gigafile' ) => 'featured'
			),
			'admin_label' => true
		),

			array(
				'type' => 'textfield',
				'heading' => esc_html__('تعداد کل آیتم ها', 'gigafile' ),
				'param_name' => 'posts_per_page',
				'std' => 10,
			),

		array(
			'type' => 'dropdown',
			'heading' => esc_html__( 'مرتب سازی بر اساس', 'gigafile' ),
			'param_name' => 'orderby',
			'value' => array(
				esc_html__( 'جدیدترین', 'gigafile' ) => 'date',
				esc_html__( 'آخرین بروزرسانی', 'gigafile' ) => 'modified',
				esc_html__( 'بیشترین فروش', 'gigafile' ) => 'sales',
				esc_html__( 'تصادفی', 'gigafile' ) => 'rand',
				esc_html__( 'قیمت', 'gigafile' ) => 'price',
			),
			),

			array(
					'type'			=> 'textfield',
					'heading'		=> __( 'شامل محصولات از دسته بندی های', 'gigafile' ),
					'param_name' 	=> 'courses_cat_include',
					'description'	=> __( 'نامک دسته بندی های مورد نظر خود را وارد کرده و با کاما "," از هم جدایشان کنید.', 'gigafile' ),
								),

			array(
			'type' => 'dropdown',
			'heading' => esc_html__( 'تعداد ستون های کروسل', 'gigafile' ),
			'param_name' => 'slides_per_view',
			'value' => array(
				10,11,12
			),
			'std' => 12,
			'group' => esc_html__( 'تنظیمات کروسل', 'gigafile' )
		),

		array(
			'type'          => 'checkbox',
			'heading'       => esc_html__( 'اجرای خودکار اسلایدر', 'gigafile' ),
			'param_name'    => 'autoplay',
			'description'   => esc_html__( 'فعالسازی حالت اجرای خودکار کروسل', 'gigafile' ),
			'dependency'  => array('element' => 'portfolio_type', 'value' => array('carousel')),
			'group' => esc_html__( 'تنظیمات کروسل', 'gigafile' )
		),

		array(
			'type'          => 'checkbox',
			'heading'       => esc_html__( 'نمایش نقطه های صفحه گذاری', 'gigafile' ),
			'param_name'    => 'show_pagination_control',
			'description'   => esc_html__( 'اگر فعال کنید ، نقطه های صفحه گذاری نمایش داده خواهد شد.', 'gigafile' ),
			'group' => esc_html__( 'تنظیمات کروسل', 'gigafile' )
		),

		array(
			'type'          => 'checkbox',
			'heading'       => esc_html__( 'نمایش دکمه های قبلی/بعدی', 'gigafile' ),
			'param_name'    => 'show_prev_next_buttons',
			'description'   => esc_html__( 'اگر تیک بزنید ، دکمه های ناوبری قبلی و بعدی اضافه خواهند شد.', 'gigafile' ),
			'group' => esc_html__( 'تنظیمات کروسل', 'gigafile' )
		),

		array(
			'type'          => 'checkbox',
			'heading'       => esc_html__( 'حلقه کروسل', 'gigafile' ),
			'param_name'    => 'wrap',
			'description'   => esc_html__( 'فعالسازی حلقه برای کروسل', 'gigafile' ),
			'dependency'  => array('element' => 'portfolio_type', 'value' => array('carousel')),
			'group' => esc_html__( 'تنظیمات کروسل', 'gigafile' )
		),

		)
	) );

	if ( class_exists('WPBakeryShortCode' ) ) {
		class WPBakeryShortCode_Cdb_Miniicon_Carousel extends WPBakeryShortCode {}
	}

}
