<?php

vc_map(array(
	'name' => esc_html__('Google Map', 'gigafile' ),
	'base' => 'cdb_google_map',
	'description'      => esc_html__( 'Shows Google map block', 'gigafile' ),
	'category' => esc_html__('Studiare', 'gigafile' ),
	'params' => array(
		array(
			'type' => 'textfield',
			'heading' => esc_html__('Map Width', 'gigafile' ),
			'param_name' => 'map_width',
			'value' => '100%',
			'description' => esc_html__('Enter map width in px or %', 'gigafile' )
		),
		array(
			'type' => 'textfield',
			'heading' => esc_html__('Map Height', 'gigafile' ),
			'param_name' => 'map_height',
			'value' => '460px',
			'description' => esc_html__('Enter map height in px', 'gigafile' )
		),
		array(
			'type' => 'attach_images',
			'heading' => esc_html__('Pin image', 'gigafile' ),
			'param_name' => 'image'
		),
		array(
			'type' => 'textfield',
			'heading' => esc_html__('Latitude', 'gigafile' ),
			'param_name' => 'lat',
			'description' => wp_kses(__('<a href="http://www.latlong.net/convert-address-to-lat-long.html">Here is a tool</a> where you can find Latitude & Longitude of your location', 'gigafile' ), array('a' => array('href' => array())))
		),
		array(
			'type' => 'textfield',
			'heading' => esc_html__('Longitude', 'gigafile' ),
			'param_name' => 'lng',
			'description' => wp_kses(__('<a href="http://www.latlong.net/convert-address-to-lat-long.html">Here is a tool</a> where you can find Latitude & Longitude of your location', 'gigafile' ), array('a' => array('href' => array())))
		),
		array(
			'type' => 'textfield',
			'heading' => esc_html__('Map Zoom', 'gigafile' ),
			'param_name' => 'map_zoom',
			'value' => 18
		),
		array(
			'type' => 'textarea_raw_html',
			'heading' => 'Map Style',
			'param_name' => 'style_json',
			'value' => '',
			'description' => wp_kses(__('Paste the style code here. Browse map styles in <a href="https://snazzymaps.com/"">SnazzyMaps</a>.', 'gigafile' ), array('a' => array('href' => array())))
		),
		array(
			'type' => 'textfield',
			'heading' => esc_html__('Your Address', 'gigafile' ),
			'param_name' => 'infowindow_text',
		),
		array(
			'type' => 'checkbox',
			'param_name' => 'disable_mouse_whell',
			'value' => array(
				esc_html__('Disable map zoom on mouse wheel scroll', 'gigafile' ) => 'disable'
			)
		),
		array(
			'type' => 'textfield',
			'heading' => esc_html__('Extra class name', 'gigafile' ),
			'param_name' => 'el_class',
			'description' => esc_html__('Style particular content element differently - add a class name and refer to it in custom CSS.', 'gigafile' )
		),
		array(
			'type' => 'css_editor',
			'heading' => esc_html__('Css', 'gigafile' ),
			'param_name' => 'css',
			'group' => esc_html__('Design options', 'gigafile' )
		)
	)
));

if ( class_exists( 'WPBakeryShortCode' ) ) {
	class WPBakeryShortCode_Cdb_Google_Map extends WPBakeryShortCode {}
}