<?php

vc_map( array(
	'base'             => 'cdb_gallery_carousel',
	'name'             => esc_html__( 'Gallery Carosuel', 'gigafile' ),
	'description'      => esc_html__( 'Show gallery in carousel', 'gigafile' ),
	'category'         => esc_html__( 'Studiare', 'gigafile' ),
	'params'           => array(
		array(
			'type'           => 'attach_images',
			'heading'        => esc_html__( 'Images', 'gigafile' ),
			'param_name'     => 'images',
			'value'          => '',
			'description'    => esc_html__( 'Select images from media library.', 'gigafile' )
		),
		array(
			'type'           => 'textfield',
			'heading'        => esc_html__( 'Image Size', 'gigafile' ),
			'param_name'     => 'img_size',
			'value'          => '',
			'description'    => esc_html__( 'Enter image size. Example: "thumbnail", "medium", "large", "full" or other sizes defined by current theme. Alternatively enter image size in pixels: 200x100 (Width x Height). Leave empty to use "thumbnail" size.', 'gigafile' )
		),

		array(
		'type' => 'dropdown',
		'heading' => esc_html__( 'تعداد ستون های کروسل', 'gigafile' ),
		'param_name' => 'slides_per_view',
		'value' => array(
			1,2,3,4,5,6,7,8
		),
		'std' => 6,
		'group'         => esc_html__( 'Carousel', 'gigafile' ),
	),
		array(
			'type'          => 'checkbox',
			'heading'       => esc_html__( 'Show Pagination', 'gigafile' ),
			'param_name'    => 'show_pagination_control',
			'description'   => esc_html__( 'If "YES" pagination control will be added', 'gigafile' ),
			'dependency'    => array( 'element' => 'view', 'value' => array('carousel') ),
			'group'         => esc_html__( 'Carousel', 'gigafile' ),
		),
		array(
			'type'          => 'checkbox',
			'heading'       => esc_html__( 'Show Prev/Next Buttons', 'gigafile' ),
			'param_name'    => 'show_prev_next_buttons',
			'description'   => esc_html__( 'If "YES" prev/next control will be added', 'gigafile' ),
			'dependency'    => array( 'element' => 'view', 'value' => array('carousel') ),
			'group'         => esc_html__( 'Carousel', 'gigafile' ),
		),
		array(
			'type'          => 'checkbox',
			'heading'       => esc_html__( 'Carousel Loop', 'gigafile' ),
			'param_name'    => 'wrap',
			'description'   => esc_html__( 'Enables loop mode for carousel', 'gigafile' ),
			'dependency'    => array( 'element' => 'view', 'value' => array('carousel') ),
			'group'         => esc_html__( 'Carousel', 'gigafile' ),
		),
		array(
			'type'           => 'dropdown',
			'heading'        => esc_html__( 'On click action', 'gigafile' ),
			'param_name'     => 'on_click',
			'value'          => array(
				esc_html__('Lightbox','gigafile' ) => 'lightbox',
				esc_html__('Custom link', 'gigafile' ) => 'links',
				esc_html__('None', 'gigafile' ) => 'none'
			),
			'group'         => esc_html__( 'Settings', 'gigafile' ),
		),
		array(
			'type'           => 'exploded_textarea_safe',
			'heading'        => esc_html__( 'Custom links', 'gigafile' ),
			'param_name'     => 'custom_links',
			'description'    => esc_html__( 'Enter links for each slide (Note: divide links with linebreaks (Enter)).', 'gigafile' ),
			'dependency'     => array(
				'element' => 'on_click',
				'value' => array( 'links' ),
			),
			'group'         => esc_html__( 'Settings', 'gigafile' ),
		),
		array(
			'type'           => 'checkbox',
			'heading'        => esc_html__( 'Open in new tab', 'gigafile' ),
			'save_always'    => true,
			'param_name'     => 'target_blank',
			'value'          => array( esc_html__( 'Yes, please', 'gigafile' ) => 'yes' ),
			'default'        => 'yes',
			'dependency'     => array(
				'element' => 'on_click',
				'value' => array( 'links' ),
			),
			'group'         => esc_html__( 'Settings', 'gigafile' ),
		),
		array(
			'type'          => 'textfield',
			'heading'       => esc_html__( 'Extra class name', 'gigafile' ),
			'param_name'    => 'el_class',
			'description'   => esc_html__( 'If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.', 'gigafile' )
		),
		array(
			'type'       => 'css_editor',
			'heading'    => esc_html__( 'Css', 'gigafile' ),
			'param_name' => 'css',
			'group'      => esc_html__( 'Design options', 'gigafile' )
		)
	)
) );

if ( class_exists( 'WPBakeryShortCode' ) ) {
	class WPBakeryShortCode_Cdb_Gallery_Carousel extends WPBakeryShortCode {}
}
