<?php

vc_map( array(
	'base'             => 'cdb_course_lessons',
	'name'             => esc_html__( 'Course Lessons', 'gigafile' ),
	'as_parent'        => array('only' => 'cdb_course_lesson'),
	'description'      => esc_html__( 'Show curriculum for course', 'gigafile' ),
	'category'         => esc_html__( 'Studiare', 'gigafile' ),
	'params'           => array(
		array(
			'type' => 'textfield',
			'heading' => esc_html__( 'Section Title', 'gigafile' ),
			'param_name' => 'title',
			'holder'	=> 'div'
		),
		array(
			'type'	 => 'checkbox',
			'heading' => esc_html__('قابلیت باز و بسته شدن بخش', 'gigafile'),
			'param_name' => 'arrow_sections',
		),
		array(
			'type'          => 'textfield',
			'heading'       => esc_html__( 'Extra class name', 'gigafile' ),
			'param_name'    => 'el_class',
			'description'   => esc_html__( 'If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.', 'gigafile' )
		),
		array(
			'type'       => 'css_editor',
			'heading'    => esc_html__( 'Css', 'gigafile' ),
			'param_name' => 'css',
			'group'      => esc_html__( 'Design options', 'gigafile' )
		)
	),
	'js_view' => 'VcColumnView'
) );

vc_map( array(
	'base'             => 'cdb_course_lesson',
	'name'             => esc_html__( 'Lesson', 'gigafile' ),
	'description'      => esc_html__( 'Course lesson', 'gigafile' ),
	'as_child'         => array('only' => 'cdb_course_lessons'),
	'category'         => esc_html__( 'Studiare', 'gigafile' ),
	'params'           => array(
		array(
			'type' => 'textfield',
			'heading' => esc_html__( 'Lesson title', 'gigafile' ),
			'param_name' => 'title',
			'holder'	=> 'div'
		),
		array(
			'description' => esc_html__('If this is video you can put video length or any other detail as short description', 'gigafile'),
			'type' => 'textfield',
			'heading' => esc_html__( 'Lesson subtitle', 'gigafile' ),
			'param_name' => 'subtitle',
			'holder'	=> 'div',
		),
		array(
			'type'	 => 'checkbox',
			'heading' => esc_html__('Private', 'gigafile'),
			'param_name' => 'private_lesson',
		),
		array(
			'type' 				=> 'iconpicker',
			'heading' 			=> esc_html__( 'Icon', 'gigafile' ),
			'param_name' 		=> 'icon',
			'value'				=> ''
		),
		array(
			'type'	=> 'textarea_html',
			'param_name' => 'content',
			'holder'	=> 'div',
			'group'	=> esc_html__('Tab Text', 'gigafile' )
		),
		array(
			'type' => 'dropdown',
			'heading' => esc_html__( 'Lesson badge', 'gigafile' ),
			'param_name' => 'badge',
			'value' => array(
				esc_html__( 'Choose Badge', 'gigafile' )	=> 'no_badge',
				esc_html__( 'Video', 'gigafile' )	=> 'video',
				esc_html__( 'Exam', 'gigafile' )		=> 'exam',
				esc_html__( 'Quiz', 'gigafile' )		=> 'quiz',
				esc_html__( 'Lecture', 'gigafile' )   => 'lecture',
				esc_html__( 'Free', 'gigafile' )		=> 'free',
				esc_html__( 'Practice', 'gigafile' )  => 'practice',
				esc_html__( 'فایل های ضمیمه', 'gigafile' )  => 'attachments',
				esc_html__( 'فایل صوتی', 'gigafile' )  => 'sound',
			),
		),
		array(
			'type' => 'textfield',
			'heading' => esc_html__( 'Preview video', 'gigafile' ),
			'description' => esc_html__('This video will be opened in popup by clicking "Preview" button (just insert link to the video), it may be youtube or vimeo link.', 'gigafile'),
			'param_name' => 'preview_video',
		),
		array(
			'type' => 'textfield',
			'heading' => esc_html__( 'لینک فایل دانلودی', 'gigafile' ),
			'description' => esc_html__('اگر لینک دانلود فایل درس را به صورت خصوصی میخواستید نمایش دهید می توانید از این گزینه استفاده کنید.', 'gigafile'),
			'param_name' => 'download_lesson',
		),
	)
) );

if ( class_exists('WPBakeryShortCodesContainer') ) {
	class WPBakeryShortCode_Cdb_Course_Lessons extends WPBakeryShortCodesContainer {}
}

if ( class_exists( 'WPBakeryShortCode' ) ) {
	class WPBakeryShortCode_Cdb_Course_Lesson extends WPBakeryShortCode {}
}
