<?php

vc_map( array(
	'base'             => 'cdb_countdown_timer',
	'name'             => esc_html__( 'Countdown timer', 'gigafile' ),
	'description'      => esc_html__( 'Shows countdown timer', 'gigafile' ),
	'category'         => esc_html__( 'Studiare', 'gigafile' ),
	'params'           => array(
		array(
			'type'          => 'textfield',
			'heading'       => esc_html__( 'Date', 'gigafile' ),
			'param_name'    => 'date',
			'admin_label'   => true,
			'description'   => esc_html__( 'Final date in the format Y/m/d. For example 2017/12/12', 'gigafile' )
		),
		array(
			'type'          => 'dropdown',
			'heading'       => esc_html__( 'Size', 'gigafile' ),
			'param_name'    => 'size',
			'value'         => array(
				esc_html__( 'Small', 'gigafile' ) => 'small',
				esc_html__( 'Medium', 'gigafile' ) => 'medium',
				esc_html__( 'Large', 'gigafile' ) => 'large',
			),
			'admin_label'   => true,
		),
		array(
			'type'          => 'dropdown',
			'heading'       => esc_html__( 'Style', 'gigafile' ),
			'param_name'    => 'style',
			'value'         => array(
				esc_html__( 'Standard', 'gigafile' ) => 'standard',
				esc_html__( 'Transparent', 'gigafile' ) => 'transparent',
			),
			'admin_label'   => true,
		),
		array(
			'type'       => 'checkbox',
			'heading'    => esc_html__( 'Light?', 'gigafile' ),
			'param_name' => 'light',
			'admin_label' => true,
			'dependency' => array('element' => 'style', 'value' => array('transparent') ),
		),
		array(
			'type'          => 'dropdown',
			'heading'       => esc_html__( 'Align', 'gigafile' ),
			'param_name'    => 'align',
			'value'         => array(
				esc_html__( 'left', 'gigafile' ) => 'left',
				esc_html__( 'center', 'gigafile' ) => 'center',
				esc_html__( 'right', 'gigafile' ) => 'right',
			),
			'admin_label'   => true,
		),
		array(
			'type' => 'textfield',
			'heading' => esc_html__( 'Extra class name', 'gigafile' ),
			'param_name' => 'el_class',
			'description' => esc_html__( 'If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.', 'gigafile' )
		),
		array(
			'type'       => 'css_editor',
			'heading'    => 'Css',
			'param_name' => 'css',
			'group'      => esc_html__( 'Design options', 'gigafile' ),
		)
	)
) );

if ( class_exists( 'WPBakeryShortCode' ) ) {
	class WPBakeryShortCode_Cdb_Countdown_Timer extends WPBakeryShortCode {}
}