<?php

vc_map( array(
	'base'             => 'cdb_clients',
	'name'             => esc_html__( 'Clients', 'gigafile' ),
	'description'      => esc_html__( 'Partners/clients logos', 'gigafile' ),
	'as_parent'        => array('only' => 'cdb_client_item'),
	'category'         => esc_html__( 'Studiare', 'gigafile' ),
	'params'           => array(
		array(
			'type'           => 'dropdown',
			'heading'        => esc_html__( 'Clients per Row', 'gigafile' ),
			'param_name'     => 'columns_count',
			'std'            => '4',
			'value'          => array(
				esc_html__( '2 Logos per Row', 'gigafile' )    => 'two',
				esc_html__( '3 Logos per Row', 'gigafile' )    => 'three',
				esc_html__( '4 Logos per Row', 'gigafile' )    => 'four',
				esc_html__( '5 Logos per Row', 'gigafile' )    => 'five',
				esc_html__( '6 Logos per Row', 'gigafile' )    => 'six',
			),
			'description' => esc_html__( 'Set number of columns for clients/partners logos.', 'gigafile' )
		),
		array(
			'type'       => 'dropdown',
			'heading'    => esc_html__( 'Spacing', 'gigafile' ),
			'param_name' => 'column_spacing',
			'std'		 => 'no',
			'value'      => array(
				esc_html__( 'No spacing', 'gigafile' )             => 'no',
				esc_html__( 'Apply default spacing', 'gigafile' )  => 'yes',
			),
			'description' => esc_html__( 'Set spacing for logo columns.', 'gigafile' )
		),
		array(
			'type'       => 'dropdown',
			'heading'    => esc_html__( 'Image Borders','gigafile' ),
			'param_name' => 'image_borders',
			'std'		 => 'yes',
			'value'      => array(
				esc_html__( 'No', 'gigafile' )     => 'no',
				esc_html__( 'Yes', 'gigafile' )    => 'yes',
			),
			'description' => esc_html__('Add borders to logo items.', 'gigafile' ),
		),
		array(
			'type'       => 'dropdown',
			'heading'    => esc_html__( 'Hover Style', 'gigafile' ),
			'param_name' => 'hover_style',
			'std'		 => 'bg-hover',
			'value'      => array(
				esc_html__( 'None', 'gigafile' )                  => 'none',
				esc_html__( 'Background hover', 'gigafile' )      => 'bg-hover',
				esc_html__( 'Image Color', 'gigafile' )             => 'color',
			),
			'description' => esc_html__( 'Select hover effect style to apply for client logos.', 'gigafile' )
		),
		array(
			'type'           => 'textfield',
			'heading'        => esc_html__( 'Image size', 'gigafile' ),
			'param_name'     => 'img_size',
			'description'    => esc_html__( 'Enter image size. Example: "thumbnail", "medium", "large", "full" or other sizes defined by current theme. Alternatively enter image size in pixels: 200x100 (Width x Height). Leave empty to use "thumbnail" size.', 'gigafile' )
		),
		array(
			'type'          => 'textfield',
			'heading'       => esc_html__( 'Extra class name', 'gigafile' ),
			'param_name'    => 'el_class',
			'description'   => esc_html__( 'If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.', 'gigafile' )
		),
		array(
			'type'       => 'css_editor',
			'heading'    => 'Css',
			'param_name' => 'css',
			'group'      => esc_html__( 'Design options', 'gigafile' ),
		)
	),
	'js_view'          => 'VcColumnView'
) );

vc_map( array(
	'base'             => 'cdb_client_item',
	'name'             => esc_html__( 'Client Logo', 'gigafile' ),
	'description'      => esc_html__( 'Add client infos', 'gigafile' ),
	'as_child'         => array('only' => 'cdb_clients'),
	'category'         => esc_html__( 'Studiare', 'gigafile' ),
	'params'           => array(
		array(
			'type'           => 'attach_image',
			'heading'        => esc_html__( 'Image', 'gigafile' ),
			'param_name'     => 'image',
			'value'          => '',
			'description'    => esc_html__( 'Add logo image here.', 'gigafile' ),
		),
		array(
			'type'           => 'textfield',
			'heading'        => esc_html__( 'Title', 'gigafile' ),
			'param_name'     => 'title',
			'admin_label'	 => true,
			'description'    => esc_html__( 'Title of the client/partner (shown on hover).', 'gigafile' ),
		),
		array(
			'type'           => 'textarea',
			'heading'        => esc_html__( 'Description', 'gigafile' ),
			'param_name'     => 'description',
			'description'    => esc_html__( 'Small description about the client/partner, this text area supports HTML too (shown on hover).', 'gigafile' ),
		),
		array(
			'type'           => 'vc_link',
			'heading'        => esc_html__( 'Link', 'gigafile' ),
			'param_name'     => 'link',
			'description'    => esc_html__( 'Make client logo clickable (Optional).', 'gigafile' ),
		),
		array(
			"type"           => "textfield",
			"heading"        => esc_html__( "Extra class name", 'gigafile' ),
			"param_name"     => "el_class",
			"description"    => esc_html__( "If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.", 'gigafile' ),
		)
	)
) );

if ( class_exists( 'WPBakeryShortCodesContainer' ) ) {
	class WPBakeryShortCode_Cdb_Clients extends WPBakeryShortCodesContainer {}
}

if ( class_exists( 'WPBakeryShortCode' ) ) {
	class WPBakeryShortCode_Cdb_Client_Item extends WPBakeryShortCode {}
}