<?php

vc_map( array(
	'base'             => 'cdb_button',
	'name'             => esc_html__( 'Button', 'gigafile' ),
	'description'      => esc_html__( 'Eye catching button', 'gigafile' ),
	'category'         => esc_html__( 'Studiare', 'gigafile' ),
	'params'           => array(
		array(
			'type' 			=> 'textfield',
			'heading' 		=> esc_html__( 'Title', 'gigafile' ),
			'param_name' 	=> 'title',
			'description'	=> esc_html__( 'Enter a button title.', 'gigafile' ),
			'value' 		=> esc_html__( 'Button with Text', 'gigafile' ),
			'admin_label'   => true
		),
		array(
			'type'			=> 'vc_link',
			'heading'		=> esc_html__( 'URL (Link)', 'gigafile' ),
			'param_name'	=> 'link',
			'description'	=> esc_html__( 'Set a button link.', 'gigafile' )
		),
		array(
			'type' 			=> 'dropdown',
			'heading' 		=> esc_html__( 'Style', 'gigafile' ),
			'param_name'	=> 'style',
			'description'	=> esc_html__( 'Select button style.', 'gigafile' ),
			'value' 		=> array(
				esc_html__( 'Filled', 'gigafile' ) => 'filled',
				esc_html__( 'Border', 'gigafile' ) => 'border',
				esc_html__( 'Link', 'gigafile' ) => 'link'
			),
			'std'			=> 'filled',
			'admin_label'   => true
		),
		array(
			'type' 			=> 'colorpicker',
			'heading' 		=> esc_html__( 'Color', 'gigafile' ),
			'param_name' 	=> 'color',
			'description'	=> esc_html__( 'Button color.', 'gigafile' )
		),
		array(
			'type' 			=> 'dropdown',
			'heading' 		=> esc_html__( 'Size', 'gigafile' ),
			'param_name'	=> 'size',
			'description'	=> esc_html__( 'Select button size.', 'gigafile' ),
			'value'			=> array(
				esc_html__( 'Large', 'gigafile' ) => 'lg',
				esc_html__( 'Medium', 'gigafile' )	=> 'md',
				esc_html__( 'Small', 'gigafile' ) => 'sm',
			),
			'std' 			=> 'lg'
		),
		array(
			'type' 			=> 'dropdown',
			'heading' 		=> esc_html__( 'Align', 'gigafile' ),
			'param_name'	=> 'align',
			'description'	=> esc_html__( 'Select button alignment.', 'gigafile' ),
			'value'			=> array(
				esc_html__( 'Left', 'gigafile' ) => 'left',
				esc_html__( 'Center', 'gigafile' )	=> 'center',
				esc_html__( 'Right', 'gigafile' ) => 'right',
				esc_html__( 'Full', 'gigafile' ) => 'full',
			),
			'std' 			=> 'left',
			'admin_label'   => true
		),
		array(
			'type'           => 'textfield',
			'heading'        => esc_html__( 'Extra class name', 'gigafile' ),
			'param_name'     => 'el_class',
			'description'    => esc_html__( 'If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.', 'gigafile' ),
		),
		array(
			'type'       => 'css_editor',
			'heading'    => 'Css',
			'param_name' => 'css',
			'group'      => esc_html__( 'Design options', 'gigafile' ),
		)
	)
) );

if ( class_exists('WPBakeryShortCode' ) ) {
	class WPBakeryShortCode_CDB_button extends WPBakeryShortCode {}
}