<?php

vc_map( array(
	'base'             => 'cdb_animated_counter',
	'name'             => esc_html__( 'Animated Counter', 'gigafile' ),
	'description'      => esc_html__( 'Shows animated counter with label', 'gigafile' ),
	'category'         => esc_html__( 'Studiare', 'gigafile' ),
	'params'           => array(
		array(
			'type'          => 'textfield',
			'heading'       => esc_html__('Actual Value','gigafile' ),
			'param_name'    => 'value',
			'description'   => esc_html__('Our final point. For ex.: 95','gigafile' ),
			'save_always'   => true,
			'admin_label'   => true,
		),
		array(
			'type'          => 'textarea',
			'heading'       => esc_html__('Label','gigafile' ),
			'param_name'    => 'label',
			'save_always'   => true,
			'admin_label'   => true,
		),
		array(
			'type'          => 'dropdown',
			'heading'       => esc_html__( 'Color scheme', 'gigafile' ),
			'param_name'    => 'color_scheme',
			'value'         => array(
				esc_html__( 'Dark', 'gigafile' ) => 'dark',
				esc_html__( 'Light', 'gigafile' ) => 'light',
				esc_html__( 'Custom', 'gigafile' ) => 'custom'
			),
			'save_always'   => true,
			'admin_label'   => true,
		),
		array(
			'type'          => 'colorpicker',
			'heading'       => esc_html__( 'Custom text color', 'gigafile' ),
			'param_name'    => 'text_color',
			'dependency'    => array(
				'element' => 'color_scheme',
				'value' => array( 'custom' )
			)
		),
		array(
			'type'           => 'textfield',
			'heading'        => esc_html__( 'Extra class name', 'gigafile' ),
			'param_name'     => 'el_class',
			'description'    => esc_html__( 'If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.', 'gigafile' ),
		),
		array(
			'type'       => 'css_editor',
			'heading'    => 'Css',
			'param_name' => 'css',
			'group'      => esc_html__( 'Design options', 'gigafile' ),
		)
	)
) );

if ( class_exists( 'WPBakeryShortCode' ) ) {
	class WPBakeryShortCode_Cdb_Animated_Counter extends WPBakeryShortCode {}
}