<?php

if ( ! class_exists( 'Redux' ) ) {
	return;
}

// This is your option name where all the Redux data is stored.
$opt_name = "codebean_option";

$studiare_selectors = codebean_get_config('selectors');

/**
 * ---> SET ARGUMENTS
 * All the possible arguments for Redux.
 * For full documentation on arguments, please refer to: https://github.com/ReduxFramework/ReduxFramework/wiki/Arguments
 * */

$theme = wp_get_theme(); // For use with some settings. Not necessary.

$codebean_social_networks_shortcode = "
<code style='font-size: 10px; display: inline-block; margin-top: 10px;'>[social_networks]</code><br>
<code style='font-size: 10px; display: inline-block; margin-top: 10px;'>[social_networks rounded]</code><br>
<code style='font-size: 10px; display: inline-block; margin-top: 10px;'>[social_networks light]</code><br>";

$args = array(
	'opt_name'             => $opt_name,
	'display_name'         => $theme->get( 'Name' ),
	'display_version'      => $theme->get( 'Version' ),
	'menu_type'            => 'menu',
	'allow_sub_menu'       => true,
	'menu_title'           => esc_html__( 'تنظیمات قالب', 'gigafile' ),
	'page_title'           => esc_html__( 'تنظیمات قالب', 'gigafile' ),
	'google_api_key'       => '',
	'google_update_weekly' => false,
	'async_typography'     => false,
	'admin_bar'            => true,
	'admin_bar_icon'       => 'dashicons-laptop',
	'admin_bar_priority'   => 50,
	'global_variable'      => '',
	'dev_mode'             => false,
	'show_options_object'  => false,
	'update_notice'        => true,
	'customizer'           => true,
	'disable_tracking'     => true,

	// OPTIONAL -> Give you extra features
	'page_priority'        => 61,
	'page_parent'          => 'themes.php',
	'page_permissions'     => 'manage_options',
	'menu_icon'            => 'dashicons-laptop',
	'last_tab'             => '',
	'page_icon'            => 'icon-themes',
	'page_slug'            => 'theme-options',
	'save_defaults'        => true,
	'default_show'         => false,
	'default_mark'         => '',
	'show_import_export'   => true,

	// CAREFUL -> These options are for advanced use only
	'transient_time'       => 60 * MINUTE_IN_SECONDS,
	'output'               => true,
	'output_tag'           => true,
	'database'             => '',
	'use_cdn'              => true,
	// HINTS
	'hints'                => array(
		'icon'          => 'el-question-sign',
		'icon_position' => 'right',
		'icon_color'    => 'lightgray',
		'icon_size'     => 'normal',
		'tip_style'     => array(
			'color'   => 'red',
			'shadow'  => true,
			'rounded' => false,
			'style'   => '',
		),
		'tip_position'  => array(
			'my' => 'top left',
			'at' => 'bottom right',
		),
		'tip_effect'    => array(
			'show' => array(
				'effect'   => 'slide',
				'duration' => '500',
				'event'    => 'mouseover',
			),
			'hide' => array(
				'effect'   => 'slide',
				'duration' => '500',
				'event'    => 'click mouseleave',
			),
		),
	)

);

Redux::setArgs( $opt_name, $args );

/*
 * ---> END ARGUMENTS
 */


/*
 *
 * ---> START SECTIONS
 *
 */

# General Settings
Redux::setSection( $opt_name, array(
	'title'             => esc_html__( 'عمومی', 'gigafile' ),
	'id'                => 'codebean_general',
	'desc'              => '',
	'customizer_width'  => '400px',
	'submenu'           => true,
	'icon'              => 'el-icon-home',
	'fields' => array(
		array (
			'id' => 'favicon',
			'type' => 'media',
			'desc' => esc_html__( 'آپلود تصویر: png, ico', 'gigafile' ),
			'operator' => 'and',
			'title' => esc_html__( 'تصویر فیوآیکون', 'gigafile' ),
		),
		array (
			'id' => 'favicon_retina',
			'type' => 'media',
			'desc' => esc_html__( 'آپلود تصویر: png, ico', 'gigafile' ),
			'operator' => 'and',
			'title' => esc_html__( 'تصویر فیوآیکون رتینا', 'gigafile' )
		),
		array(
			'id'       => 'studiare_preloader',
			'type'     => 'switch',
			'title'    => esc_html__('فعالسازی بارگیری صفحه', 'gigafile' ),
			'default'  => false
		),
		array(
			'id'       => 'preloader_icon',
			'type'     => 'select',
			'title'    => esc_html__('فعالسازی بارگیری صفحه', 'gigafile' ),
			'default'  => 'circle',
			'options'   => array(
				'circle' => esc_html__( 'چرخی', 'gigafile' ),
				'square-boxes' => esc_html__( 'مربعی', 'gigafile' )
			),
			'required' => array('studiare_preloader', '=', true),
			'select2'   => array('allowClear' => false)
		),
		array(
			'id'        => 'google_api_key',
			'type'      => 'text',
			'title'     => esc_html__( 'کلید API گوگل', 'gigafile' ),
			'description' => esc_html__( 'Enter here the secret api key you have created on Google APIs', 'gigafile' )
		)
	)
) );


# Header Settings
Redux::setSection( $opt_name, array(
	'title' => esc_html__( 'تنظیمات عمومی سربرگ', 'gigafile' ),
	'id' => 'header',
	'icon' => 'el-icon-wrench'
) );


Redux::setSection( $opt_name, array(
	'title' => esc_html__( 'تنظیمات عمومی', 'gigafile' ),
	'id' => 'header_general',
	'subsection' => true,
	'fields' => array(

		array(
			'id'        => 'header_type',
			'type'      => 'select',
			'title'     => esc_html__('نوع سربرگ', 'gigafile' ),
			'subtitle'  => esc_html__( 'انتخاب کنید کدام نوع سربرگ می خواهید نمایش داده شود', 'gigafile' ),
			'default'   => 'h_v1',
			'options'   => array(
				'h_v1' => esc_html__( 'ورژن 1', 'gigafile' ),
				'h_v2'  => esc_html__( 'ورژن 2', 'gigafile' ),
			),
		),

		array(
			'id'       => 'header_full_width',
			'type'     => 'switch',
			'title'    => esc_html__( 'تمام عرض', 'gigafile' ),
			'subtitle' => esc_html__( 'سربرگ را تمام عرض کنید.', 'gigafile' ),
			'default'  => false,
		),

		array(
			'id'       => 'header_sticky_menu',
			'type'     => 'switch',
			'title'    => esc_html__( 'منوی چسبان', 'gigafile' ),
			'subtitle' => esc_html__( 'فعال و غیر فعال کردن منوی سربرگ چسبان', 'gigafile' ),
			'default'  => true,
		),

		array(
			'id' => 'custom_logo_image',
			'type' => 'media',
			'desc' => esc_html__('آپلود تصویر: png, jpg or gif file', 'gigafile' ),
			'operator' => 'and',
			'title' => esc_html__('تصویر لوگوی سربرگ', 'gigafile' ),
		),

		array(
			'id' => 'footer_logo_',
			'type' => 'media',
			'desc' => esc_html__('یک لوگو برای نمایش در وسط فوتر آپلود کنید.', 'gigafile' ),
			'operator' => 'and',
			'title' => esc_html__('تصویر لوگوی وسط فوتر', 'gigafile' ),
		),
		array(
			'id'        => 'logo_img_width',
			'type'      => 'slider',
			'title'     => esc_html__('Logo image maximum width (px)', 'gigafile' ),
			'desc'      => esc_html__('Set maximum width for logo image in the header. In pixels', 'gigafile' ),
			"default"   => 200,
			"min"       => 50,
			"step"      => 1,
			"max"       => 600,
			'display_value' => 'label',
			'tags'     => 'logo width logo size'
		),
		array(
			'id'             => 'logo_padding',
			'type'           => 'spacing',
			'mode'           => 'padding',
			'units'          => array('px'),
			'units_extended' => 'false',
			'title'          => esc_html__('فاصله های داخلی لوگو', 'gigafile' ),
			'desc'           => esc_html__('Add some spacing around your logo image', 'gigafile' ),
			'default'            => array(
				'padding-top'     => '10px',
				'padding-right'   => '20px',
				'padding-bottom'  => '10px',
				'padding-left'    => '0px',
				'units'          => 'px',
			),
			'tags'     => 'logo padding logo spacing',
			'select2'   => array('allowClear' => false)
		),

	),
) );


Redux::setSection( $opt_name, array(
	'title' => esc_html__( 'چیدمان سربرگ', 'gigafile' ),
	'id' => 'branding',
	'subsection' => true,
	'fields' => array(
		array(
			'id'        => 'header_height',
			'type'      => 'slider',
			'title'     => esc_html__('ارتفاع سربرگ', 'gigafile' ),
			"default"   => 112,
			"min"       => 40,
			"step"      => 1,
			"max"       => 220,
			'display_value' => 'label',
			'tags'     => 'header size logo height logo size'
		),


		array(
			'id'        => 'header_button',
			'type'      => 'switch',
			'title'     => esc_html__( 'دکمه ی سربرگ', 'gigafile' ),
			'subtitle'  => esc_html__( 'Show/hide button on header right', 'gigafile' ),
			'default'   => true,
		),
		array(
			'id'        => 'header_button_link',
			'type'      => 'select',
			'title'     => esc_html__( 'لینک دکمه', 'gigafile' ),
			'subtitle'  => esc_html__( 'Choose link you want to add on button', 'gigafile' ),
			'default'   => 'account',
			'options'   => array(
				'account' => esc_html__( 'لینک به حساب کاربری', 'gigafile' ),
				'custom'  => esc_html__( 'Custom link', 'gigafile' ),
			),
			'required'  => array('header_button', '=', true),
			'select2'   => array('allowClear' => false)
		),

		array(
			'id'        => 'header_button_custom_text_after_login',
			'type'      => 'text',
			'title'     => esc_html__( 'متن دکمه سربرگ بعد از لاگین', 'gigafile' ),
			'default'   => 'حساب کاربری',
			'required'  => array('header_button_link', '=', 'account'),
		),

		array(
			'id'        => 'header_button_custom_text',
			'type'      => 'text',
			'title'     => esc_html__( 'متن دکمه سفارشی', 'gigafile' ),
			'required'  => array('header_button_link', '=', 'custom'),
		),
		array(
			'id'        => 'header_button_custom_link',
			'type'      => 'text',
			'title'     => esc_html__( 'لینک دکمه سفارشی', 'gigafile' ),
			'required'  => array('header_button_link', '=', 'custom'),
		)
	),
) );


Redux::setSection( $opt_name, array(
	'title' => esc_html__( 'ناحیه عنوان صفحات', 'gigafile' ),
	'id' => 'header-title',
	'subsection' => true,
	'fields' => array(

		array(
			'id'       => 'header_text_color',
			'type'     => 'color',
			'title'    => esc_html__( 'رنگ متن ناحیه عنوان سربرگ', 'gigafile' ),
			'validate' => 'color',
			'transparent' => false,
			'output'   => $studiare_selectors['header_text_color'],
			'default'  => '#0a0909'
		),

		array(
			'id'        => 'header_title_bg',
			'type'      => 'background',
			'title'     => esc_html__( 'رنگ پس زمینه ناحیه عنوان صفحات', 'gigafile' ),
			'background-image' => true,
			'background-position' => true,
			'background-attachment' => true,
			'background-size' => true,
			'background-repeat' => true,
			'preview' => true,
			'output'   => '.page-title',
			'default'  => array(
				'background-color' => '#ebeef1'
			),

		),



	)
) );

Redux::setSection( $opt_name, array(
	'title' => esc_html__( 'نوار بالای سربرگ', 'gigafile' ),
	'id' => 'header-topbar',
	'subsection' => true,
	'fields' => array(
		array(
			'id'        => 'topbar_display_opt',
			'type'      => 'switch',
			'title'     => esc_html__( 'نوار بالا', 'gigafile' ),
			'subtitle'  => esc_html__( 'Information about the header', 'gigafile' ),
			'default'   => true,
		),
		array(
			'id'        => 'topbar_color',
			'type'      => 'select',
			'title'     => esc_html__( 'رنگ متن نوار بالای سربرگ', 'studiare' ),
			'default'   => 'light',
			'options'   => array(
				'dark' => esc_html__( 'Dark', 'studiare' ),
				'light'  => esc_html__( 'Light', 'studiare' )
			),
			'required'  => array('topbar_display_opt', '=', '1'),
			'select2'   => array('allowClear' => false)
		),
		array(
			'id'       => 'top-bar-bg',
			'type'     => 'background',
			'title'    => esc_html__( 'پس زمینه نوار بالای سربرگ', 'gigafile' ),
			'background-image' => false,
			'background-position' => false,
			'background-attachment' => false,
			'background-size' => false,
			'background-repeat' => false,
			'transparent' => false,
			'preview' => false,
			'output'   => '.top-bar',
			'default'  => array(
				'background-color' => '#2e3e77'
			),
			'required'  => array('topbar_display_opt', '=', '1'),
		),
		array(
			'id'        => 'topbar_search',
			'type'      => 'switch',
			'title'     => esc_html__( 'نمایش و مخفی کردن جستجو', 'gigafile' ),
			'default'   => true,
		),
		array(
			'id'        => 'topbar_cart',
			'type'      => 'switch',
			'title'     => esc_html__( 'نمایش و مخفی کردن سبد خرید', 'gigafile' ),
			'default'   => true,
		),
		array(
			'id'        => 'pup_up_button',
			'type'      => 'switch',
			'title'     => esc_html__( 'پاپ آپ ورود به حساب کاربری در حالت موبایل', 'gigafile' ),
			'default'   => true,
		)
	)
) );

Redux::setSection( $opt_name, array(
	'title' => esc_html__( 'منوی موبایل', 'gigafile' ),
	'id' => 'mobile-nav',
	'subsection' => true,
	'fields' => array(
		array(
			'id' => 'off_canvas_search',
			'type' => 'switch',
			'title' => esc_html__( 'جستجو در منوی موبایل', 'gigafile' ),
			'subtitle' => esc_html__( 'Show/hide search form on mobile navigation', 'gigafile' ),
			'default' => true
		),
		array(
			'id' => 'off_canvas_cart',
			'type' => 'switch',
			'title' => esc_html__( 'سبد خرید در منوی موبایل', 'gigafile' ),
			'subtitle' => esc_html__( 'Show/hide shopping cart on mobile navigation', 'gigafile' ),
			'default' => true
		),
		array(
			'id' => 'off_canvas_footer',
			'type' => 'editor',
			'title' => esc_html__( 'متن یا شرتکد برای نمایش در منوی موبایل', 'gigafile' ),
			'subtitle' => esc_html__( 'Place here text you want to see in the mobile nav footer area. You can use shortocdes. Ex.: [social_buttons]', 'gigafile' )
		),
	)
) );




# Header V2 Settings
Redux::setSection( $opt_name, array(
	'title' => esc_html__( 'سربرگ ورژن دو', 'gigafile' ),
	'id' => 'header-v2',
	'icon' => 'el-icon-wrench'
) );


Redux::setSection( $opt_name, array(
	'title' => esc_html__( 'منوی عمودی', 'gigafile' ),
	'id' => 'vertical_menu',
	'subsection' => true,
	'fields' => array(

		array(
			'id'      => 'vertical_menu_text',
			'type'    => 'text',
			'default'  => 'دسترسی سریع',
			'title'   => esc_html__( 'متن دکمه منوی عمودی', 'gigafile' ),
		),


	),
) );




# Styling
Redux::setSection( $opt_name, array(
	'title' => esc_html__( 'رنگ و استایل', 'gigafile' ),
	'id' => 'colors',
	'icon' => 'el-icon-brush',
	'fields' => array(
		array(
			'id'       => 'primary_color',
			'type'     => 'color',
			'title'    => esc_html__( 'رنگ اصلی', 'gigafile' ),
			'validate' => 'color',
			'transparent' => false,
			'output'   => $studiare_selectors['primary_color'],
			'default'  => '#fea000'
		),
		array(
			'id'       => 'secondary_color',
			'type'     => 'color',
			'title'    => esc_html__( 'رنگ ثانویه', 'gigafile' ),
			'validate' => 'color',
			'transparent' => false,
			'output'   => $studiare_selectors['secondary_color'],
			'default'  => '#434343'
		)
	)
) );

# Typography
Redux::setSection( $opt_name, array(
	'title' => esc_html__('تایپوگرافی', 'gigafile' ),
	'id' => 'typography',
	'icon' => 'el-icon-fontsize',
	'fields' => array(
		array(
			'id'             => 'font_body',
			'type'           => 'typography',
			'title'          => esc_html__( 'Body', 'gigafile' ),
			'compiler'       => true,
			'google'         => true,
			'font-backup'    => false,
			'font-weight'    => true,
			'all_styles'     => true,
			'text-align'     => true,
			'font-style'     => false,
			'subsets'        => false,
			'font-size'      => true,
			'line-height'    => true,
			'word-spacing'   => false,
			'letter-spacing' => false,
			'color'          => true,
			'preview'        => true,
			'output'         => array( 'body' ),
			'units'          => 'px',
			'subtitle'       => esc_html__( 'Select custom font for your main body text.', 'gigafile' ),
			'default'        => array(
				'color'       => "#7d7e7f",
				'font-size'   => '15px',
				'line-height' => '24px',
				'font-family' => 'Iransans',
				'google'      => true,
				'font-backup' => "'MS Sans Serif', Geneva, sans-serif"
			)
		),
		array(
			'id'             => 'menu_heading',
			'type'           => 'typography',
			'title'          => esc_html__( 'Menu', 'gigafile' ),
			'compiler'       => true,
			'google'         => true,
			'font-backup'    => false,
			'font-weight'    => true,
			'all_styles'     => true,
			'text-align'     => true,
			'font-style'     => false,
			'subsets'        => false,
			'font-size'      => true,
			'line-height'    => true,
			'word-spacing'   => false,
			'letter-spacing' => false,
			'color'          => true,
			'preview'        => true,
			'output'         => array( '.studiare-navigation ul.menu>li>a, .studiare-navigation .menu>ul>li>a' ),
			'units'          => 'px',
			'subtitle'       => esc_html__( 'Select custom font for menu', 'gigafile' ),
			'default'        => array(
				'font-family' => 'Iransans',
				'font-weight' => '400',
				'font-size'   => '16px'
			)
		),
		array(
			'id'             => 'submenu_font',
			'type'           => 'typography',
			'title'          => esc_html__( 'Sub Menu', 'gigafile' ),
			'compiler'       => true,
			'google'         => true,
			'font-backup'    => false,
			'font-weight'    => true,
			'all_styles'     => true,
			'text-align'     => true,
			'font-style'     => false,
			'subsets'        => false,
			'font-size'      => true,
			'line-height'    => true,
			'word-spacing'   => false,
			'letter-spacing' => false,
			'color'          => true,
			'preview'        => true,
			'output'         => array( '.studiare-navigation ul.menu>li ul li>a, .studiare-navigation .menu>ul>li ul li>a' ),
			'units'          => 'px',
			'subtitle'       => esc_html__( 'Select custom font for sub menu', 'gigafile' ),
			'default'        => array(
				'font-family' => 'Iransans',
				'font-size' => '14px',
				'font-weight' => '400',
			)
		),
		array(
			'id'             => 'h1_params',
			'type'           => 'typography',
			'title'          => esc_html__( 'H1', 'gigafile' ),
			'compiler'       => true,
			'google'         => true,
			'font-backup'    => false,
			'font-weight'    => true,
			'all_styles'     => true,
			'text-align'     => true,
			'font-style'     => false,
			'subsets'        => false,
			'font-size'      => true,
			'line-height'    => true,
			'word-spacing'   => false,
			'letter-spacing' => false,
			'color'          => true,
			'preview'        => true,
			'output'         => array( 'h1,.h1' ),
			'units'          => 'px',
			'default'        => array(
				'font-size' => '26px',
				'font-weight' => '400',
				'color'       => '#464749',
				'font-family' => 'Iransans',
				'google'      => true,
			)
		),
		array(
			'id'             => 'h2_params',
			'type'           => 'typography',
			'title'          => esc_html__( 'H2', 'gigafile' ),
			'compiler'       => true,
			'google'         => true,
			'font-backup'    => false,
			'font-weight'    => true,
			'all_styles'     => true,
			'text-align'     => true,
			'font-style'     => false,
			'subsets'        => false,
			'font-size'      => true,
			'line-height'    => true,
			'word-spacing'   => false,
			'letter-spacing' => false,
			'color'          => true,
			'preview'        => true,
			'output'         => array( 'h2,.h2' ),
			'units'          => 'px',
			'default'        => array(
				'font-size' => '24px',
				'font-weight' => '400',
				'color'       => '#464749',
				'font-family' => 'Iransans',
				'google'      => true,
			)
		),
		array(
			'id'             => 'h3_params',
			'type'           => 'typography',
			'title'          => esc_html__( 'H3', 'gigafile' ),
			'compiler'       => true,
			'google'         => true,
			'font-backup'    => false,
			'font-weight'    => true,
			'all_styles'     => true,
			'text-align'     => true,
			'font-style'     => false,
			'subsets'        => false,
			'font-size'      => true,
			'line-height'    => true,
			'word-spacing'   => false,
			'letter-spacing' => false,
			'color'          => true,
			'preview'        => true,
			'output'         => array( 'h3,.h3' ),
			'units'          => 'px',
			'default'        => array(
				'font-size' => '22px',
				'font-weight' => '400',
				'color'       => '#464749',
				'font-family' => 'Iransans',
				'google'      => true,
			)
		),
		array(
			'id'             => 'h4_params',
			'type'           => 'typography',
			'title'          => esc_html__( 'H4', 'gigafile' ),
			'compiler'       => true,
			'google'         => true,
			'font-backup'    => false,
			'font-weight'    => true,
			'all_styles'     => true,
			'text-align'     => true,
			'font-style'     => false,
			'subsets'        => false,
			'font-size'      => true,
			'line-height'    => true,
			'word-spacing'   => false,
			'letter-spacing' => false,
			'color'          => true,
			'preview'        => true,
			'output'         => array( 'h4,.h4' ),
			'units'          => 'px',
			'default'        => array(
				'font-size' => '18px',
				'font-weight' => '500',
				'color'       => '#464749',
				'font-family' => 'Iransans',
				'google'      => true,
			)
		),
		array(
			'id'             => 'h5_params',
			'type'           => 'typography',
			'title'          => esc_html__( 'H5', 'gigafile' ),
			'compiler'       => true,
			'google'         => true,
			'font-backup'    => false,
			'font-weight'    => true,
			'all_styles'     => true,
			'text-align'     => true,
			'font-style'     => false,
			'subsets'        => false,
			'font-size'      => true,
			'line-height'    => true,
			'word-spacing'   => false,
			'letter-spacing' => false,
			'color'          => true,
			'preview'        => true,
			'output'         => array( 'h5,.h5' ),
			'units'          => 'px',
			'default'        => array(
				'font-size' => '18px',
				'font-weight' => '500',
				'color'       => '#464749',
				'font-family' => 'Iransans',
				'google'      => true,
			)
		),
		array(
			'id'             => 'h6_params',
			'type'           => 'typography',
			'title'          => esc_html__( 'H6', 'gigafile' ),
			'compiler'       => true,
			'google'         => true,
			'font-backup'    => false,
			'font-weight'    => true,
			'all_styles'     => true,
			'text-align'     => true,
			'font-style'     => false,
			'subsets'        => false,
			'font-size'      => true,
			'line-height'    => true,
			'word-spacing'   => false,
			'letter-spacing' => false,
			'color'          => true,
			'preview'        => true,
			'output'         => array( 'h6,.h6' ),
			'units'          => 'px',
			'default'        => array(
				'font-size' => '16px',
				'font-weight' => '500',
				'color'       => '#464749',
				'font-family' => 'Iransans',
				'google'      => true,
			)
		),
	)
) );

# Blog Settings
Redux::setSection( $opt_name, array(
	'title' => esc_html__( 'بلاگ', 'gigafile' ),
	'id' => 'blog',
	'icon' => 'el-icon-pencil',

) );

Redux::setSection( $opt_name, array(
	'title'            => esc_html__( 'تنظمیات بلاگ', 'gigafile' ),
	'id'               => 'blog_settings',
	'subsection'       => true,
	'fields'           => array(
		array(
			'id'        => 'blog_post_style',
			'type'      => 'button_set',
			'title'     => esc_html__( 'چیدمان نوشته های بلاگ', 'gigafile' ),
			'subtitle'  => esc_html__( 'Choose the form you want to show blog posts', 'gigafile' ),
			'default'   => 'list',
			'options'   => array(
				'list' => esc_html__( 'نمایش لیستی', 'gigafile' ),
				'grid' => esc_html__( 'نمایش شبکه ای', 'gigafile' ),
			)
		),
		array(
			'id' => 'blog_grid_columns',
			'type' => 'select',
			'title' => esc_html__( 'ستون های شبکه بلاگ', 'gigafile' ),
			'subtitle' => esc_html__( 'How many columns you want in a row', 'gigafile' ),
			'default' => 'three',
			'options' => array(
				'one' => esc_html__( 'یک ستونه', 'gigafile' ),
				'two' => esc_html__( 'دو ستونه', 'gigafile' ),
				'three' => esc_html__( 'سه ستونه', 'gigafile' ),
				'four' => esc_html__( 'چهار ستونه', 'gigafile' )
			),
			'select2'   => array('allowClear' => false),
			'required'  => array('blog_post_style', '=', 'grid')
		),
		array(
			'id'        => 'sidebar_position',
			'type'      => 'image_select',
			'title'     => esc_html__( 'موقعیت سایدبار آرشیو نوشته ها', 'gigafile' ),
			'subtitle'  => esc_html__( 'Set blog sidebar position or hide it', 'gigafile' ),
			'default'   => 'right',
			'options'   => array(
				'none'      => array(
					'alt'   => esc_html__( 'بدون سایدبار', 'gigafile' ),
					'img'   => ReduxFramework::$_url.'assets/img/1col.png'
				),
				'left'      => array(
					'alt'   => esc_html__( 'سایدبار چپ', 'gigafile' ),
					'img'   => ReduxFramework::$_url.'assets/img/2cl.png'
				),
				'right'      => array(
					'alt'   => esc_html__( 'سایدبار راست', 'gigafile' ),
					'img'  => ReduxFramework::$_url.'assets/img/2cr.png'
				),
			)
		),
		array(
			'id'        => 'sidebar_position_single',
			'type'      => 'image_select',
			'title'     => esc_html__( 'موقعیت سایدبار نوشته های تکی', 'gigafile' ),
			'subtitle'  => esc_html__( 'Set blog sidebar position or hide it', 'gigafile' ),
			'default'   => 'right',
			'options'   => array(
				'none'      => array(
					'alt'   => esc_html__( 'No Sidebar', 'gigafile' ),
					'img'   => ReduxFramework::$_url.'assets/img/1col.png'
				),
				'left'      => array(
					'alt'   => esc_html__( 'Sidebar Left', 'gigafile' ),
					'img'   => ReduxFramework::$_url.'assets/img/2cl.png'
				),
				'right'      => array(
					'alt'   => esc_html__( 'Sidebar Right', 'gigafile' ),
					'img'  => ReduxFramework::$_url.'assets/img/2cr.png'
				),
			)
		),
		array(
			'id'        => 'article_author',
			'type'      => 'switch',
			'title'     => esc_html__( 'Display Author Info?', 'gigafile' ),
			'subtitle'  => esc_html__( 'Displays author information at the bottom. Will only be displayed if the author description is filled.', 'gigafile' ),
			'default'   => true,
		),
		array(
			'id'        => 'blog_navigation',
			'type'      => 'switch',
			'title'     => esc_html__( 'Display Article Navigation?', 'gigafile' ),
			'subtitle'  => esc_html__( 'Displays article navigation after post content.', 'gigafile' ),
			'default'   => true,
		),
		array(
			'id'        => 'blog_related',
			'type'      => 'switch',
			'title'     => esc_html__( 'نمایش نوشته های مرتبط؟', 'gigafile' ),
			'subtitle'  => esc_html__( 'انتخاب کنید که آیا نوشته های مرتبط بعد از محتوای نوشته نمایش داده شود؟', 'gigafile' ),
			'default'   => true,
		),

		array(
			'id'        => 'blog_meta_data',
			'type'      => 'switch',
			'title'     => esc_html__( 'نمایش اطلاعات نوشته تکی؟', 'gigafile' ),
			'subtitle'  => esc_html__( 'انتخاب کنید که آیا اطلاعات نوشته مثل تاریخ و دسته بندی و آماز بازدید نمایش داده شود یا خیر', 'gigafile' ),
			'default'   => true,
		),

		array(
			'id'        => 'blog_featured_img',
			'type'      => 'switch',
			'title'     => esc_html__( 'نمایش تصویر شاخص نوشته های بلاگ؟', 'gigafile' ),
			'subtitle'  => esc_html__( 'انتخاب کنید که می خواهید تصویر شاخص نوشته های بلاگ در صفحه نوشته تکی نمایش داده شود یا خیر؟', 'gigafile' ),
			'default'   => true,
		),

		array(
			'id'      => 'report_form',
			'type'    => 'text',
			'title'   => esc_html__( 'شرتکد فرم گزارش مشکل دانلود', 'studiare' ),
			'subtitle' => esc_html__( 'یک فرم با فرم ساز دلخواه خود بسازید و شرتکد آن را جهت نمایش در اینجا قرار دهید.', 'studiare' ),
		),

	)
) );

$share_story_networks = array(
	'enabled' => array(
		'placebo'	=> 'placebo',
		'fb'   	 	=> 'Facebook',
		'tw'   	 	=> 'Twitter',
		'lin'       => 'LinkedIn',
		'tlr'       => 'Tumblr',
		'gp'       	=> 'Google Plus',
	),
	'disabled' => array(
		'placebo'   => 'placebo',
		'pi'       	=> 'Pinterest',
		'em'       	=> 'Email',
		'vk'       	=> 'VKontakte',
	),
);

Redux::setSection( $opt_name, array(
	'title'            => esc_html__( 'تنظیمات اشتراک گذاری', 'gigafile' ),
	'id'               => 'sharing_settings',
	'subsection'       => true,
	'fields'           => array(
		array(
			'id'       => 'blog_share_story',
			'title'    => esc_html__( 'Share Story', 'gigafile' ),
			'subtitle' => esc_html__( 'Enable or disable sharing blog post on social networks', 'gigafile' ),
			'type'     => 'switch',
			'default'  => true,
			'on'       => esc_html__( 'Allow Share', 'gigafile' ),
			'off'      => esc_html__( 'No', 'gigafile' ),
		),

	)
) );

# Footer Settings
Redux::setSection( $opt_name, array(
	'title'             => esc_html__( 'تنظیمات فوتر', 'gigafile' ),
	'id'                => 'footer_settings',
	'desc'              => esc_html__( 'Every footer option is included here.', 'gigafile' ),
	'customizer_width'  => '400px',
	'icon'              => 'el-icon-photo',
	'fields'            => array(
		array(
			'id'        => 'footer_visibility',
			'type'      => 'switch',
			'title'     => esc_html__( 'نمایش یا مخفی کردن فوتر', 'gigafile' ),
			'subtitle'  => esc_html__( 'Show or hide footer globally', 'gigafile' ),
			'default'   => true,
		),
		array(
			'id'        => 'footer_waves_visiblity',
			'type'      => 'switch',
			'title'     => esc_html__( 'موج های بالای فوتر', 'gigafile' ),
			'subtitle'  => esc_html__( 'نمایش یا مخفی کردن موج های بالای فوتر', 'gigafile' ),
			'default'   => true,
		),
		array(
			'id'        => 'footer_color_scheme',
			'type'      => 'select',
			'title'     => esc_html__( 'رنگ متن فوتر', 'gigafile' ),
			'subtitle'  => esc_html__( 'Choose your footer color scheme', 'gigafile' ),
			'default'   => 'light',
			'options'   => array(
				'dark' => esc_html__( 'Dark', 'gigafile' ),
				'light'  => esc_html__( 'Light', 'gigafile' )
			),
			'select2'   => array('allowClear' => false)
		),
		array(
			'id'       => 'footer-widgets-bg',
			'type'     => 'background',
			'title'    => esc_html__( 'Footer background', 'gigafile' ),
			'output'   => '.site-footer, .ltx-overlay-black-waves',
			'default'  => array(
				'background-color' => '#2e3e77'
			)
		),
		array(
			'id'        => 'footer_widgets',
			'type'      => 'switch',
			'required'  => array('footer_visibility', '=' , '1'),
			'title'     => esc_html__( 'Footer Widgets', 'gigafile' ),
			'subtitle'  => esc_html__( 'Show or hide footer widgets', 'gigafile' ),
			'default'   => true,
		),
		array(
			'id'        => 'footer_columns',
			'type'      => 'image_select',
			'required'  => array('footer_widgets', '=', '1'),
			'title'     => esc_html__( 'Footer Columns', 'gigafile' ),
			'subtitle'  => esc_html__( 'Set columns layout for footer to split widgets.', 'gigafile' ),
			'default'   => 'three',
			'options'   => array(
				'four'   => array(
					'alt'   => '4 Columns',
					'img' => get_parent_theme_file_uri('assets/images/admin/footer-4.png' ),
				),
				'three'  => array(
					'alt'   => '3 Columns',
					'img' => get_parent_theme_file_uri('assets/images/admin/footer-3.png' ),
				),
				'two'    => array(
					'alt'   => '2 Columns',
					'img' => get_parent_theme_file_uri('assets/images/admin/footer-2.png' ),
				),
				'doubleleft'    => array(
					'alt'   => 'Double Left',
					'img' => get_parent_theme_file_uri('assets/images/admin/footer-double-left.png'),
				),
				'doubleright'   => array(
					'alt'   => 'Double Right',
					'img' => get_parent_theme_file_uri('assets/images/admin/footer-double-right.png'),
				),
				'one'     => array(
					'alt'   => '1 Column',
					'img' => get_parent_theme_file_uri('assets/images/admin/footer-1.png'),
				),
			),
		),
		array(
			'id'       => 'disable_copyrights',
			'type'     => 'switch',
			'title'    => esc_html__('Copyrights', 'gigafile' ),
			'default' => true
		),
		array(
			'id'       => 'copyrights-layout',
			'type'     => 'select',
			'title'    => esc_html__('Copyrights layout', 'gigafile' ),
			'options'  => array(
				'two-columns' => esc_html__('Two columns', 'gigafile' ),
				'centered' => esc_html__('Centered', 'gigafile' ),
			),
			'default' => 'two-columns'
		),
		array(
			'id'       => 'copyrights-layout',
			'type'     => 'select',
			'title'    => esc_html__('Copyrights layout', 'gigafile' ),
			'options'  => array(
				'default' => esc_html__('Two columns', 'gigafile' ),
				'centered' => esc_html__('Centered', 'gigafile' ),
			),
			'default' => 'default',
			'select2'   => array('allowClear' => false)
		),
		array(
			'id'       => 'copyrights',
			'type'     => 'text',
			'title'    => esc_html__('Copyrights text', 'gigafile' ),
			'subtitle' => esc_html__('Place here text you want to see in the copyrights area. You can use shortocdes. Ex.: [social_networks]', 'gigafile' ),
		),
		array(
			'id'       => 'copyrights2',
			'type'     => 'text',
			'title'    => esc_html__('Text next to copyrights', 'gigafile' ),
			'subtitle' => esc_html__('You can use shortcodes. Ex.: [social_networks]', 'gigafile' ),
		),
		array(
			'id'       => 'scroll_top_btn',
			'type'     => 'switch',
			'title'    => esc_html__( 'Scroll to top button', 'gigafile' ),
			'default' => true
		),
	)
) );

# My Account Settings
Redux::setSection( $opt_name, array(
	'title' => esc_html__( 'ثبت نام و ورود', 'gigafile' ),
	'id' => 'log_reg',
	'icon' => 'el el-user',

) );

Redux::setSection( $opt_name, array(
	'title'            => esc_html__( 'تنظیمات عضویت و ورود', 'gigafile' ),
	'id'               => 'log_reg_settings',
	'subsection'       => true,
	'fields' => array(

		array(
			'id' => 'content_log_reg',
			'type' => 'editor',
			'title' => esc_html__( 'محتوای کنار فرم عضویت و ورود', 'gigafile' ),
		)

	)

) );


# Courses Settings
Redux::setSection( $opt_name, array(
	'title' => esc_html__( 'Courses', 'gigafile' ),
	'id' => 'courses',
	'icon' => 'el-icon-shopping-cart',

) );


Redux::setSection( $opt_name, array(
	'title'            => esc_html__( 'Course Settings', 'gigafile' ),
	'id'               => 'course_settings',
	'subsection'       => true,
	'fields' => array(
		array(
			'id'        => 'shop_sidebar',
			'type'      => 'image_select',
			'title'     => esc_html__( 'Sidebar Position', 'gigafile' ),
			'subtitle'  => esc_html__( 'Set shop sidebar position or hide it', 'gigafile' ),
			'default'   => 'right',
			'options'   => array(
				'none'      => array(
					'alt'   => esc_html__( 'No Sidebar', 'gigafile' ),
					'img'   => ReduxFramework::$_url.'assets/img/1col.png'
				),
				'left'      => array(
					'alt'   => esc_html__( 'Sidebar Left', 'gigafile' ),
					'img'   => ReduxFramework::$_url.'assets/img/2cl.png'
				),
				'right'      => array(
					'alt'   => esc_html__( 'Sidebar Right', 'gigafile' ),
					'img'  => ReduxFramework::$_url.'assets/img/2cr.png'
				),
			)
		),
		array(
			'id'        => 'courses_columns',
			'type'      => 'select',
			'title'     => esc_html__( 'Courses Columns', 'gigafile' ),
			'subtitle'  => esc_html__( 'Choose columns for courses grid', 'gigafile' ),
			'options'   => array(
				'2' => esc_html__( 'Two Columns', 'gigafile' ),
				'3' => esc_html__( 'Three Columns', 'gigafile' ),
				'4' => esc_html__( 'Four Columns', 'gigafile' ),
			),
			'default'   => '3',
			'select2'   => array('allowClear' => false)
		),
		array(
			'id'       => 'shop_per_page',
			'type'     => 'text',
			'title'    => esc_html__( 'Courses per page', 'gigafile' ),
			'subtitle' => esc_html__( 'Number of courses per page', 'gigafile' ),
			'default'  => '8',
			'min'      => '1',
			'max'      => '20',
		),

		array(
			'id'       => 'course_video_loop',
			'title'    => esc_html__( 'نمایش ویدئوی پیشنمایش در آرشیو محصولات', 'gigafile' ),
			'subtitle' => esc_html__( 'با فعال کردن این گزینه، ویدئوی پیشنمایش محصولات در صفحه آرشیو قابل اجرا روی تصویر کاور خواهد بود', 'gigafile' ),
			'type'     => 'switch',
			'default'  => false,
			'on'       => esc_html__( 'فعال', 'gigafile' ),
			'off'      => esc_html__( 'غیر فعال', 'gigafile' )
		),

		array(
			'id'       => 'download_gallery_loop',
			'title'    => esc_html__( 'نمایش اسلایدر گالری تصاویر محصول هنگام هاور', 'gigafile' ),
			'subtitle' => esc_html__( 'با فعال کردن این گزینه ، هنگاکی که کاربر تصویر کاور محصول را هاور کند ، گالری سایر تصاویر محصول به صورت اسلایدری قالب نمایش خواهد بود.', 'gigafile' ),
			'type'     => 'switch',
			'default'  => false,
			'on'       => esc_html__( 'فعال', 'gigafile' ),
			'off'      => esc_html__( 'غیر فعال', 'gigafile' )
		),

	)
) );
Redux::setSection( $opt_name, array(
	'title'            => esc_html__( 'صفحه محصول تکی', 'gigafile' ),
	'id'               => 'course_page_settings',
	'subsection'       => true,
	'fields' => array(


		array(
			'id'      => 'add_to_cart_text',
			'type'    => 'text',
			'default'  => 'خرید این محصول',
			'title'   => esc_html__( 'متن سفارشی دکمه خرید محصول', 'gigafile' ),
		),

		array(
			'id'        => 'course_single_sidebar_position',
			'type'      => 'image_select',
			'title'     => esc_html__( 'موقعیت سایدبار صفحه محصول تکی', 'gigafile' ),
			'subtitle'  => esc_html__( 'موقعیت سایدبار برگه محصول تکی را انتخاب کنید.', 'gigafile' ),
			'default'   => 'right',
			'options'   => array(
				'left'      => array(
					'alt'   => esc_html__( 'Sidebar Left', 'gigafile' ),
					'img'   => ReduxFramework::$_url.'assets/img/2cl.png'
				),
				'right'      => array(
					'alt'   => esc_html__( 'Sidebar Right', 'gigafile' ),
					'img'  => ReduxFramework::$_url.'assets/img/2cr.png'
				),
			)
		),

		array(
			'id'       => 'course_downloads',
			'title'    => esc_html__( 'دریافت فایل های محصول', 'gigafile' ),
			'subtitle' => esc_html__( 'نمایش و مخفی کردن بخش دریافت فایل های محصول', 'gigafile' ),
			'type'     => 'switch',
			'default'  => false,
			'on'       => esc_html__( 'نمایش', 'gigafile' ),
			'off'      => esc_html__( 'مخفی', 'gigafile' )
		),

		array(
			'id'       => 'course_students',
			'title'    => esc_html__( 'تعداد فروش محصول', 'gigafile' ),
			'subtitle' => esc_html__( 'نمایش یا مخفی کردن تعداد فروش محصولات', 'gigafile' ),
			'type'     => 'switch',
			'default'  => true,
			'on'       => esc_html__( 'نمایش', 'gigafile' ),
			'off'      => esc_html__( 'مخفی', 'gigafile' )
		),
		array(
			'id'       => 'course_counters',
			'title'    => esc_html__( 'آمار بازدید و تعداد نظرات', 'gigafile' ),
			'subtitle' => esc_html__( 'نمایش و مخفی کردن بخش تعداد بازدید و نظرات', 'gigafile' ),
			'type'     => 'switch',
			'default'  => true,
			'on'       => esc_html__( 'نمایش', 'gigafile' ),
			'off'      => esc_html__( 'مخفی', 'gigafile' )
		),

		array(
			'id'       => 'related_courses_display',
			'title'    => esc_html__( 'نمایش / مخی کردن محصولات مشابه', 'gigafile' ),
			'subtitle' => esc_html__( 'با استفاده از این گزینه می توانید محصولات مشابه را در برگه محصول مخفی کنید.', 'gigafile' ),
			'type'     => 'switch',
			'default'  => true,
			'on'       => esc_html__( 'نمایش', 'gigafile' ),
			'off'      => esc_html__( 'مخفی', 'gigafile' )
		),
		array(
			'id'       => 'course_per_page',
			'type'     => 'text',
			'title'    => esc_html__( 'تعداد محصولات مشابه', 'gigafile' ),
			'subtitle' => esc_html__( 'تعداد محصولات مشابه قابل نمایش در برگه محصول', 'gigafile' ),
			'default'  => '6',
			'min'      => '1',
			'max'      => '10',
		),

		array(
			'id' => 'content_review_rules',
			'type' => 'editor',
			'title' => esc_html__( 'محتوای بلوک قوانین ثبت نظر در تب نظرات محصول', 'gigafile' ),
		)

	)
) );


Redux::setSection( $opt_name, array(
	'title'            => esc_html__( 'Sharing Settings', 'gigafile' ),
	'id'               => 'course_sharing_settings',
	'subsection'       => true,
	'fields'           => array(
		array(
			'id'       => 'course_share_story',
			'title'    => esc_html__( 'Share Course', 'gigafile' ),
			'subtitle' => esc_html__( 'Enable or disable sharing course on social networks', 'gigafile' ),
			'type'     => 'switch',
			'default'  => true,
			'on'       => esc_html__( 'Allow Share', 'gigafile' ),
			'off'      => esc_html__( 'No', 'gigafile' )
		)
	)
) );


# Social Media Links
$social_networks_ordering = array(
	'enabled' => array (
		'placebo'	=> 'placebo',
		'fb'   	 	=> 'Facebook',
		'tw'   	 	=> 'Twitter',
		'ig'        => 'Instagram',
		'vm'        => 'Vimeo',
		'be'        => 'Behance',
		'fs'        => 'Foursquare',
		'custom'    => 'Custom Link',
	),
	'disabled' => array (
		'placebo'   => 'placebo',
		'gp'        => "Google+",
		'lin'       => 'LinkedIn',
		'yt'        => 'YouTube',
		'drb'       => 'Dribbble',
		'pi'        => 'Pinterest',
		'vk'        => 'VKontakte',
		'da'        => 'DeviantArt',
		'fl'        => 'Flickr',
		'vi'        => 'Vine',
		'tu'        => 'Tumblr',
		'sk'        => 'Skype',
		'gh'        => 'GitHub',
		'hz'        => 'Houzz',
		'px'        => '500px',
		'xi'        => 'Xing',
		'sn'        => 'Snapchat',
		'em'        => 'Email',
		'yp'        => 'Yelp',
		'ta'        => 'TripAdvisor',
		'aparat'    => 'آپارات',
	),
);

Redux::setSection( $opt_name, array(
	'title'             => esc_html__( 'شبکه های اجتماعی', 'gigafile' ),
	'id'                => 'social_networks',
	'desc'              => '',
	'customizer_width'  => '400px',
	'submenu'           => true,
	'icon'              => 'fa fa-share-alt',
	'fields'            => array(
		// Social Networks Ordering
		array(
			'id'        => 'social_order',
			'type'      => 'sorter',
			'title'     => esc_html__( 'Social Networks Ordering', 'gigafile' ),
			'subtitle'  => "Set the appearing order of social networks in the footer. To use social networks links list copy this shortcode:<br><br> " . $codebean_social_networks_shortcode,
			'options'   => $social_networks_ordering,
		),
		array(
			'id'        => 'social_networks_target_attr',
			'type'      => 'select',
			'title'     => esc_html__( 'هدف لینک', 'gigafile' ),
			'subtitle'  => esc_html__( 'Open social links in new window or current window', 'gigafile' ),
			'default'   => '_blank',
			'options'   => array(
				'_self' => esc_html__( 'همان پنجره', 'gigafile' ),
				'_blank' => esc_html__( 'پنجره جدید', 'gigafile' ),
			),
			'select2'   => array('allowClear' => false)
		),
		array(
			'id'       => 'social_network_link_aparat',
			'type'     => 'text',
			'title'    => 'آپارات',
			'placeholder' => 'https://www.aparat.com/username',
			'default'  => '',
		),
		array(
			'id'       => 'social_network_aparat_link_icon',
			'type'     => 'text',
			'title'    => 'نام آیکون آپارات',
			'desc'     => 'بنویسید: aparat',
			'placeholder' => 'مثلا: aparat',
			'default'  => 'aparat',
		),

		array(
			'id'       => 'social_network_link_fb',
			'type'     => 'text',
			'title'    => 'Facebook',
			'placeholder' => 'https://facebook.com/username',
			'default'  => '',
		),
		array(
			'id'       => 'social_network_link_tw',
			'type'     => 'text',
			'title'    => 'Twitter',
			'placeholder' => 'https://twitter.com/username',
			'default'  => '',
		),
		array(
			'id'       => 'social_network_link_lin',
			'type'     => 'text',
			'title'    => 'Linkedin',
			'placeholder' => 'https://linkedin.com/in/username',
			'default'  => '',
		),
		array(
			'id'       => 'social_network_link_yt',
			'type'     => 'text',
			'title'    => 'YouTube',
			'placeholder' => 'https://youtube.com/user/username',
			'default'  => '',
		),
		array(
			'id'       => 'social_network_link_vm',
			'type'     => 'text',
			'title'    => 'Vimeo',
			'placeholder' => 'https://vimeo.com/username',
			'default'  => '',
		),
		array(
			'id'       => 'social_network_link_drb',
			'type'     => 'text',
			'title'    => 'Dribbble',
			'placeholder' => 'https://dribbble.com/username',
			'default'  => '',
		),
		array(
			'id'       => 'social_network_link_ig',
			'type'     => 'text',
			'title'    => 'Instagram',
			'placeholder' => 'https://instagram.com/username',
			'default'  => '',
		),
		array(
			'id'       => 'social_network_link_pi',
			'type'     => 'text',
			'title'    => 'Pinterest',
			'placeholder' => 'https://pinterest.com/username',
			'default'  => '',
		),
		array(
			'id'       => 'social_network_link_gp',
			'type'     => 'text',
			'title'    => 'Google Plus',
			'placeholder' => 'https://plus.google.com/username',
			'default'  => '',
		),
		array(
			'id'       => 'social_network_link_vk',
			'type'     => 'text',
			'title'    => 'VKontakte',
			'placeholder' => 'https://vk.com/username',
			'default'  => '',
		),
		array(
			'id'       => 'social_network_link_da',
			'type'     => 'text',
			'title'    => 'DeviantArt',
			'placeholder' => 'https://username.deviantart.com/',
			'default'  => '',
		),
		array(
			'id'       => 'social_network_link_tu',
			'type'     => 'text',
			'title'    => 'Tumblr',
			'placeholder' => 'https://username.tumblr.com/',
			'default'  => '',
		),
		array(
			'id'       => 'social_network_link_vi',
			'type'     => 'text',
			'title'    => 'Vine',
			'placeholder' => 'https://vine.com/username',
			'default'  => '',
		),
		array(
			'id'       => 'social_network_link_be',
			'type'     => 'text',
			'title'    => 'Behance',
			'placeholder' => 'https://behance.com/username',
			'default'  => '',
		),
		array(
			'id'       => 'social_network_link_fl',
			'type'     => 'text',
			'title'    => 'Flickr',
			'placeholder' => 'https://flickr.com/photos/username',
			'default'  => '',
		),
		array(
			'id'       => 'social_network_link_fs',
			'type'     => 'text',
			'title'    => 'Foursquare',
			'placeholder' => 'https://foursquare.com/username',
			'default'  => '',
		),
		array(
			'id'       => 'social_network_link_sk',
			'type'     => 'text',
			'title'    => 'Skype',
			'placeholder' => 'skype:username',
			'default'  => '',
		),
		array(
			'id'       => 'social_network_link_gh',
			'type'     => 'text',
			'title'    => 'GitHub',
			'placeholder' => 'https://github.com/username',
			'default'  => '',
		),
		array(
			'id'       => 'social_network_link_hz',
			'type'     => 'text',
			'title'    => 'Houzz',
			'placeholder' => 'https://houzz.com/user/username',
			'default'  => '',
		),
		array(
			'id'       => 'social_network_link_px',
			'type'     => 'text',
			'title'    => '500px',
			'placeholder' => 'https://500px.com/username',
			'default'  => '',
		),
		array(
			'id'       => 'social_network_link_vi',
			'type'     => 'text',
			'title'    => 'Xing',
			'placeholder' => 'https://xing.com/profile/username',
			'default'  => '',
		),
		array(
			'id'       => 'social_network_link_sn',
			'type'     => 'text',
			'title'    => 'Snapchat',
			'placeholder' => 'https://snapchat.com/add/username',
			'default'  => '',
		),
		array(
			'id'       => 'social_network_link_yp',
			'type'     => 'text',
			'title'    => 'Yelp',
			'placeholder' => 'https://yelp.com/biz/alias',
			'default'  => '',
		),
		array(
			'id'       => 'social_network_link_ta',
			'type'     => 'text',
			'title'    => 'Trip Advisor',
			'placeholder' => 'https://tripadvisor.com',
			'default'  => '',
		),
		array(
			'id'       => 'social_network_link_em',
			'type'     => 'text',
			'title'    => 'Contact Email',
			'placeholder' => 'john.doe@email.com',
			'default'  => '',
		),
		array(
			'id'       => 'social_network_link_em_subject',
			'type'     => 'text',
			'title'    => 'Contact Subject',
			'placeholder' => 'Hello!',
			'default'  => '',
		),
		array(
			'id'       => 'social_network_custom_link_title',
			'type'     => 'text',
			'title'    => 'Custom Link',
			'placeholder' => 'Custom Link Title',
			'default'  => '',
		),
		array(
			'id'       => 'social_network_custom_link_link',
			'type'     => 'text',
			'title'    => 'Link',
			'placeholder' => 'https://www.mywebsite.com/',
			'default'  => '',
		),
		array(
			'id'       => 'social_network_custom_link_icon',
			'type'     => 'text',
			'title'    => 'Custom Link Icon',
			'desc'     => 'Icon (optional)<br><small>Note: If you want to set custom icon, enter icon alias from <a href="http://fontawesome.io/icons/" target="_blank">Font Awesome</a> icon collection.</small>',
			'placeholder' => 'Example: bookmark',
			'default'  => '',
		),

	)
) );

/*
 * <--- END SECTIONS
 */

// Function used to retrieve theme option values
if ( ! function_exists( 'codebean_option' ) ) {
	function codebean_option( $id, $fallback = false, $param = false ) {
		global $codebean_option;
		if ( $fallback == false ) $fallback = '';
		$output = ( isset( $codebean_option[$id] ) && $codebean_option[$id] !== '' ) ? $codebean_option[$id] : $fallback;
		if ( !empty( $codebean_options[$id] ) && $param ) {
			$output = $codebean_options[$id][$param];
		}
		return $output;
	}
}
