<?php
/**
 * The header for our theme
 */
?> <!DOCTYPE html>
<html itemscope itemtype="http://schema.org/WebPage" <?php language_attributes(); ?>>
<head>
	<!-- Google Tag Manager -->
<script>(function(w,d,s,l,i){w[l]=w[l]||[];w[l].push({'gtm.start':
new Date().getTime(),event:'gtm.js'});var f=d.getElementsByTagName(s)[0],
j=d.createElement(s),dl=l!='dataLayer'?'&l='+l:'';j.async=true;j.src=
'https://www.googletagmanager.com/gtm.js?id='+i+dl;f.parentNode.insertBefore(j,f);
})(window,document,'script','dataLayer','GTM-5TTBPSG');</script>
<!-- End Google Tag Manager -->
	
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no" />
	<link rel="profile" href="http://gmpg.org/xfn/11">
	<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>">

	<!-- Global site tag (gtag.js) - Google Analytics -->
<script async src="https://www.googletagmanager.com/gtag/js?id=G-Q6DJRDJYKK"></script>
<script>
  window.dataLayer = window.dataLayer || [];
  function gtag(){dataLayer.push(arguments);}
  gtag('js', new Date());

  gtag('config', 'G-Q6DJRDJYKK');
</script>

	<?php wp_head(); ?>
	
</head>
<body <?php body_class(); ?>>
<!-- Google Tag Manager (noscript) -->
<noscript><iframe src="https://www.googletagmanager.com/ns.html?id=GTM-5TTBPSG"
height="0" width="0" style="display:none;visibility:hidden"></iframe></noscript>
<!-- End Google Tag Manager (noscript) -->
	
<?php do_action( 'studiare_before_body' ); ?>
<!---start GOFTINO code--->
<script type="text/javascript">
  !function(){var i="lj2cBY",a=window,d=document;function g(){var g=d.createElement("script"),s="https://www.goftino.com/widget/"+i,l=localStorage.getItem("goftino_"+i);g.async=!0,g.src=l?s+"?o="+l:s;d.getElementsByTagName("head")[0].appendChild(g);}"complete"===d.readyState?g():a.attachEvent?a.attachEvent("onload",g):a.addEventListener("load",g,!1);}();
</script>
<!---end GOFTINO code--->
<?php

$header_button = true;
$header_button_link = 'account';
$account_link = get_permalink( get_option('woocommerce_myaccount_page_id') );

if ( class_exists('Redux') ) {
	$header_button = codebean_option('header_button');
	$header_button_link = codebean_option('header_button_link');
	$header_type = codebean_option ('header_type');
} ?>

<?php if ( ( $header_button ) && ( $header_button_link == 'account' ) ) : ?>
    <div class="modal">
        <div class="login-form-overlay"></div>
        <div class="login-form-modal">
            <div class="login-form-modal-inner">
                <div class="login-form-modal-box">
                    <a href="javascript:void(0)" class="close">
                        <?php get_template_part('/assets/images/close-icon.svg'); ?>
                    </a>
                    <div class="login-form-header">
                        <p class="login-title"><?php esc_html_e( 'Sign In', 'gigafile' ); ?></p>
                    </div>
                    <div class="login-form-content">
                
                        <?php get_template_part('/inc/templates/login-modal' ); ?>
                       
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php endif; ?>
	<div class="video_popup_wrrapper">
	<div class="video_popup_overlay"></div>
		<div class="video_popup_inner"></div>
	</div>
<div class="wrap">

    <?php if ( studiare_needs_header() ): ?>
	
	<?php if ( $header_type == 'h_v1' ) : ?>

        <?php get_template_part('/inc/templates/header/top-bar' ); ?>
        <?php get_template_part( '/inc/templates/header/header-main' ); ?>
        <?php get_template_part('/inc/templates/page-title'); ?>
	
	<?php elseif ( $header_type == 'h_v2' ) : ?>
	
		<?php get_template_part('/inc/templates/header/top-bar-2' ); ?>
		<?php get_template_part( '/inc/templates/header/header-main-2' ); ?>
		<?php get_template_part('/inc/templates/page-title'); ?>

    <?php endif; ?>
	<?php endif; ?>