<?php


if ( !class_exists( 'ReduxFramework' ) && file_exists( dirname( __FILE__ ) . '/inc/plugins/ReduxFramework/ReduxCore/framework.php' ) ) {
    require_once( dirname( __FILE__ ) . '/inc/plugins/ReduxFramework/ReduxCore/framework.php' );
}

/**
 * Studiare functions and definitions
 */

# Constants
define('GIGAFILE_THEMEDIR', 		get_theme_file_path() . '/');
define('GIGAFILE_THEMEURL', 		get_theme_file_uri() . '/');
define('GIGAFILE_THEMEASSETS',  GIGAFILE_THEMEURL . 'assets/');
define('GIGAFILE_TD', 		      'gigafile');
define('GIGAFILE_TS', 	        microtime(true));

# Initial Actions
add_action( 'after_setup_theme',    'gigafile_after_setup_theme' );
add_action('init', 				    'gigafile_init');

add_action('wp_enqueue_scripts',    'gigafile_wp_enqueue_scripts');

if (!isset($content_width)) {
	$content_width = 1120;
}

require get_parent_theme_file_path( '/inc/codebean_functions.php' );

# Libraries
require get_parent_theme_file_path('/inc/tgm/tgm-plugin-registration.php');

# Slider post type
function wms_slider_init() {
    $labels = array(
        'name' => 'اسلایدر',
        'singular_name' => 'اسلایدر',
        'add_new' => 'افزودن اسلاید',
        'add_new_item' => 'افزودن اسلاید جدید',
        'edit_item' => 'ویرایش اسلاید',
        'new_item' => 'اسلاید جدید',
        'all_items' => 'همه اسلایدها',
        'view_item' => 'مشاهده اسلاید',
        'search_items' => 'Search Sliders',
        'not_found' =>  'No Slider found',
        'not_found_in_trash' => 'No Slider found in Trash',
        'parent_item_colon' => '',
        'menu_name' => 'اسلایدر'
    );

    $args = array(
        'labels' => $labels,
        'description'   => 'Holds our Slider poste specific data',
        'public' => true,
        'publicly_queryable' => false,
        'show_ui' => true,
        'menu_icon'           => 'dashicons-images-alt2',
        'show_in_menu' => true,
        'query_var' => true,
        'rewrite' => array( 'slug' => 'slider' ),
        'capability_type' => 'post',
        'has_archive' => false,
        'hierarchical' => true,
        'menu_position' => 5,
        'supports' => array( 'title', 'editor', 'thumbnail', 'page-attributes')
    );
    register_post_type( 'slider', $args );
}
add_action( 'init', 'wms_slider_init' );
add_action( 'init', 'wms_create_slider_taxonomies', 0 );

//create SlideShow Category for the post type "slider"
function wms_create_slider_taxonomies() {

    // Add new taxonomy, make it hierarchical (like categories)
    $labels = array(
        'name'                => _x( 'SlideShows', 'taxonomy general name' ),
        'singular_name'       => _x( 'SlideShow', 'taxonomy singular name' ),
        'search_items'        => __( 'Search Genres' ),
        'all_items'           => __( 'All SlideShows' ),
        'parent_item'         => __( 'Parent SlideShow' ),
        'parent_item_colon'   => __( 'Parent SlideShow:' ),
        'edit_item'           => __( 'Edit SlideShow' ),
        'update_item'         => __( 'Update SlideShow' ),
        'add_new_item'        => __( 'Add New SlideShow' ),
        'new_item_name'       => __( 'New SlideShow Name' ),
        'menu_name'           => __( 'دسته بندی اسلایدر' )
    );

    $args = array(
        'hierarchical'        => true,
        'labels'              => $labels,
        'show_ui'             => true,
        'show_admin_column'   => true,
        'query_var'           => true,
        'rewrite'             => array( 'slug' => 'slideshow' )
    );
    register_taxonomy( 'slideshow', array( 'slider' ), $args );
}

function add_class_value_in_any_lang($badge_code){
	switch($badge_code){
		case 'free':
		$result = 'رایگان';
		break;
		$result = '';
		break;
		case 'video':
		$result = 'ویدئو';
		break;
		$result = '';
		break;
		case 'exam':
		$result = 'آزمون';
		break;
		$result = '';
		break;
		case 'quiz':
		$result = 'کوئیز';
		break;
		$result = '';
		break;
		case 'lecture':
		$result = 'مقاله';
		break;
		$result = '';
		break;
		case 'practice':
		$result = 'تمرین';
		break;
		$result = '';
		break;
		case 'attachments':
		$result = 'فایل های ضمیمه';
		break;
		$result = '';
		break;
		case 'sound':
		$result = 'فایل صوتی';
		break;
		$result = '';
		break;
	}
	return $result;
}


# Widgets
require get_parent_theme_file_path( '/inc/widgets/contacts.php' );
require get_parent_theme_file_path( '/inc/widgets/banner-widget.php' );

if ( !isset( $redux_demo ) && file_exists( dirname( __FILE__ ) . '/inc/codebean_options.php' ) ) {
	require_once( dirname( __FILE__ ) . '/inc/codebean_options.php' );
}

function woo_mini_wallet_callback() {
    if (!function_exists('woo_wallet') || !is_user_logged_in()) {
        return '';
    }
    ob_start();
    $title = __('Current wallet balance', 'woo-wallet');
    $mini_wallet = '<a class="woo-wallet-menu-contents" href="' . esc_url(wc_get_account_endpoint_url(get_option('woocommerce_woo_wallet_endpoint', 'woo-wallet'))) . '" title="' . $title . '">';
    $mini_wallet .= woo_wallet()->wallet->get_wallet_balance(get_current_user_id());
    $mini_wallet .= '</a>';
    echo $mini_wallet;
    return ob_get_clean();
}
add_shortcode('woo-mini-wallet', 'woo_mini_wallet_callback');

function rm_post_view_count(){
	if ( is_single() ){
		global $post;
		$count_post = esc_attr( get_post_meta( $post->ID, '_post_views_count', true) );
		if( $count_post == ''){
			$count_post = 1;
			add_post_meta( $post->ID, '_post_views_count', $count_post);
		}else{
			$count_post = (int)$count_post + 1;
			update_post_meta( $post->ID, '_post_views_count', $count_post);
		}
	}
}
add_action('wp_head', 'rm_post_view_count');


/*
 * کد افزودن لیست علاقه مندی به پیشخوان مشتریان
 */
add_filter ( 'woocommerce_account_menu_items', 'misha_log_history_link', 40 );
function misha_log_history_link( $menu_links ){

	$menu_links = array_slice( $menu_links, 0, 3, true )
	+ array( 'mywishlist' => 'علاقه مندی ها' )
	+ array_slice( $menu_links, 3, NULL, true );

	return $menu_links;

}
/*
 * Step 2. Register Permalink Endpoint
 */
add_action( 'init', 'misha_add_endpoint' );
function misha_add_endpoint() {

	// WP_Rewrite is my Achilles' heel, so please do not ask me for detailed explanation
	add_rewrite_endpoint( 'mywishlist', EP_PAGES );
}
/*
 * Step 3. Content for the new page in My Account, woocommerce_account_{ENDPOINT NAME}_endpoint
 */
add_action( 'woocommerce_account_mywishlist_endpoint', 'misha_my_account_endpoint_content' );
function misha_my_account_endpoint_content() {

	// of course you can print dynamic content here, one of the most useful functions here is get_current_user_id()
	echo do_shortcode('[yith_wcwl_wishlist]');

}



// get video address ajax

function get_video_ajax(){

	$post_id=$_POST['post_id'];
	$url=$_POST['url'];
	if(empty($post_id)){
		echo $url;
	}else{
	 echo $course_video = get_post_meta($post_id, '_studiare_course_video', true);
	}
	wp_die();
}

add_action('wp_ajax_get_video_ajax', 'get_video_ajax');
add_action('wp_ajax_nopriv_get_video_ajax', 'get_video_ajax');






// [product_count] shortcode
function download_count_shortcode( ) {
	$count_posts = wp_count_posts( 'product' );
	return $count_posts->publish;
}
add_shortcode( 'download_count', 'download_count_shortcode' );


function the_dramatist_price_show() {
    global $product;
    if( $product->is_on_sale() ) {
        return $product->get_sale_price();
    }
    return $product->get_regular_price();
}

/*
// sina
add_action( 'woocommerce_save_account_details_errors','billing_phone_field_validation', 20, 1 );
function billing_phone_field_validation( $args ){
    if ( isset($_POST['billing_phone']) && empty($_POST['billing_phone']) )
        $args->add( 'error', __( 'شماره موبایل خود را وارد کنید!', 'woocommerce' ),'');
}

add_action( 'woocommerce_save_account_details', 'my_account_saving_billing_phone', 20, 1 );
function my_account_saving_billing_phone( $user_id ) {
    if( isset($_POST['billing_phone']) && ! empty($_POST['billing_phone']) )
        update_user_meta( $user_id, 'billing_phone', sanitize_text_field($_POST['billing_phone']) );
	    update_user_meta( $user_id, 'digits_phone', '+98'.sanitize_text_field($_POST['billing_phone']));
	    update_user_meta( $user_id, 'digits_phone_no', sanitize_text_field($_POST['billing_phone']) );
	    update_user_meta( $user_id, 'digt_countrycode', '+98' );
}


add_action('woocommerce_after_order_notes', 'my_custom_checkout_field');
function my_custom_checkout_field( $checkout ) {
		 woocommerce_form_field( 'digits_phones', array( 
		'type' 			=> 'text', 
		'class' 		=> array('woocommerce-account-fields'), 
		'required'		=> true,
		'placeholder' 	=> __('Enter a number'),
		), $checkout->get_value( 'digits_phones' ));
}
add_action('woocommerce_checkout_update_user_meta', 'my_custom_checkout_field_update_user_meta');
function my_custom_checkout_field_update_user_meta( $user_id ) {
	if ($user_id && $_POST['digits_phones'])
		update_user_meta( $user_id, 'digits_phone', esc_attr($_POST['digits_phones']) );
	    update_user_meta( $user_id, 'digits_phone_no', esc_attr (substr($_POST['digits_phones'],-10)) );
	    update_user_meta( $user_id, 'digt_countrycode', '+98' );	
}
function wpse215677_checkout_fields ( $fields ) {
    $fields['billing_phone']['maxlength'] = 10;
    return $fields;
}
add_filter('woocommerce_billing_fields', 'wpse215677_checkout_fields');
function my_woocommerce_add_error( $error ) {
    return str_replace('An account is already registered with your email address. Please log in','کاربرگرامی؛ شما قبلا ثبت نام کرده اید. برای خرید لطفا <a href="#" class="showlogin">وارد</a> شوید',$error);    
}
add_filter( 'woocommerce_add_error', 'my_woocommerce_add_error' );
/*
 * Rich Snippet Data
 * Add missing data not handled by WooCommerce yet - Webjame.Com
 */

function custom_woocommerce_structured_data_product ($data) {
	global $product;
	
	$data['mpn'] = $product->get_sku() ?? null;
	
	return $data;
}
add_filter( 'woocommerce_structured_data_product', 'custom_woocommerce_structured_data_product' );
// Webjame.Com : Fixed Product Brand Schema
require_once dirname(__FILE__) . '/functions-fixed-brand-schema.php';



//قابلیت کپی کردن برگه ها

/*
 * Function for post duplication. Dups appear as drafts. User is redirected to the edit screen
 */
function rd_duplicate_post_as_draft(){
  global $wpdb;
  if (! ( isset( $_GET['post']) || isset( $_POST['post'])  || ( isset($_REQUEST['action']) && 'rd_duplicate_post_as_draft' == $_REQUEST['action'] ) ) ) {
    wp_die('No post to duplicate has been supplied!');
  }
  /*
   * Nonce verification
   */
  if ( !isset( $_GET['duplicate_nonce'] ) || !wp_verify_nonce( $_GET['duplicate_nonce'], basename( __FILE__ ) ) )
    return;
  /*
   * get the original post id
   */
  $post_id = (isset($_GET['post']) ? absint( $_GET['post'] ) : absint( $_POST['post'] ) );
  /*
   * and all the original post data then
   */
  $post = get_post( $post_id );
  /*
   * if you don't want current user to be the new post author,
   * then change next couple of lines to this: $new_post_author = $post->post_author;
   */
  $current_user = wp_get_current_user();
  $new_post_author = $current_user->ID;
  /*
   * if post data exists, create the post duplicate
   */
  if (isset( $post ) && $post != null) {
    /*
     * new post data array
     */
    $args = array(
      'comment_status' => $post->comment_status,
      'ping_status'    => $post->ping_status,
      'post_author'    => $new_post_author,
      'post_content'   => $post->post_content,
      'post_excerpt'   => $post->post_excerpt,
      'post_name'      => $post->post_name,
      'post_parent'    => $post->post_parent,
      'post_password'  => $post->post_password,
      'post_status'    => 'draft',
      'post_title'     => $post->post_title,
      'post_type'      => $post->post_type,
      'to_ping'        => $post->to_ping,
      'menu_order'     => $post->menu_order
    );
    /*
     * insert the post by wp_insert_post() function
     */
    $new_post_id = wp_insert_post( $args );
    /*
     * get all current post terms ad set them to the new post draft
     */
    $taxonomies = get_object_taxonomies($post->post_type); // returns array of taxonomy names for post type, ex array("category", "post_tag");
    foreach ($taxonomies as $taxonomy) {
      $post_terms = wp_get_object_terms($post_id, $taxonomy, array('fields' => 'slugs'));
      wp_set_object_terms($new_post_id, $post_terms, $taxonomy, false);
    }
    /*
     * duplicate all post meta just in two SQL queries
     */
    $post_meta_infos = $wpdb->get_results("SELECT meta_key, meta_value FROM $wpdb->postmeta WHERE post_id=$post_id");
    if (count($post_meta_infos)!=0) {
      $sql_query = "INSERT INTO $wpdb->postmeta (post_id, meta_key, meta_value) ";
      foreach ($post_meta_infos as $meta_info) {
        $meta_key = $meta_info->meta_key;
        if( $meta_key == '_wp_old_slug' ) continue;
        $meta_value = addslashes($meta_info->meta_value);
        $sql_query_sel[]= "SELECT $new_post_id, '$meta_key', '$meta_value'";
      }
      $sql_query.= implode(" UNION ALL ", $sql_query_sel);
      $wpdb->query($sql_query);
    }
    /*
     * finally, redirect to the edit post screen for the new draft
     */
    wp_redirect( admin_url( 'post.php?action=edit&post=' . $new_post_id ) );
    exit;
  } else {
    wp_die('Post creation failed, could not find original post: ' . $post_id);
  }
}
add_action( 'admin_action_rd_duplicate_post_as_draft', 'rd_duplicate_post_as_draft' );
/*
 * Add the duplicate link to action list for post_row_actions
 */
function rd_duplicate_post_link( $actions, $post ) {
  if (current_user_can('edit_posts')) {
    $actions['duplicate'] = '<a href="' . wp_nonce_url('admin.php?action=rd_duplicate_post_as_draft&post=' . $post->ID, basename(__FILE__), 'duplicate_nonce' ) . '" title="Duplicate this item" rel="permalink">Duplicate</a>';
  }
  return $actions;
}
add_filter( 'page_row_actions', 'rd_duplicate_post_link', 10, 2 );


//کمترین قیمت محصولات متغیر
add_filter( 'woocommerce_variable_sale_price_html', 'wc_wc20_variation_price_format', 10, 2 );
add_filter( 'woocommerce_variable_price_html', 'wc_wc20_variation_price_format', 10, 2 );
function wc_wc20_variation_price_format( $price, $product ) {
// Main Price
$prices = array( $product->get_variation_price( 'min', true ), $product->get_variation_price( 'max', true ) );
$price = $prices[0] !== $prices[1] ? sprintf( __( '%1$s', 'woocommerce' ), wc_price( $prices[0] ) ) : wc_price( $prices[0] );
// Sale Price
$prices = array( $product->get_variation_regular_price( 'min', true ), $product->get_variation_regular_price( 'max', true ) );
sort( $prices );
$saleprice = $prices[0] !== $prices[1] ? sprintf( __( '%1$s', 'woocommerce' ), wc_price( $prices[0] ) ) : wc_price( $prices[0] );
if ( $price !== $saleprice ) {
$price = '<del>' . $saleprice . '</del> <ins>' . $price . '</ins>';
}
return $price;
}


add_filter( 'get_shortlink', function( $shortlink ) {return $shortlink;} );

