<?php
/**
 * Webjame.Com : Fixed Product brand schema
 *
 * https://webjame.com/fixed-product-schema-for-woocommerce/
 */
// Block direct access.
defined('WPINC') || die();
function add_brand_to_product_schema($data) {
   if (!is_array($data)) {
      // If $data isn't an array, don't do anything.
   } elseif (empty($product = wc_get_product())) {
      // Don't do anything.
   } elseif (!is_array($brands = wc_get_product_terms($product->get_id(), 'pa_brand', array('fields' => 'names')))) {
      // This product has no brands associated with it.
   } elseif (empty($brands)) {
      // This product has zero brands associated with it.
   } elseif (count($brands) == 1) {
      // This product has exactly one brand associated with it.
      $data['brand'] = array('@type' => 'Brand', 'name' => $brands[0]);
   } else {
      // This product has multiple brands associated with it.
      $data['brand'] = array();
      foreach ($brands as $brand) {
         $data['brand'][] = array('@type' => 'Brand', 'name' => $brand);
      }
   }
   return $data;
}
add_filter('woocommerce_structured_data_product', 'add_brand_to_product_schema');